/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.addon.databinding.runtime.collection;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.viatra.addon.databinding.runtime.collection.IObservablePatternMatchCollectionUpdate;
import org.eclipse.viatra.addon.databinding.runtime.collection.ObservableCollectionProcessor;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.ViatraQueryMatcher;
import org.eclipse.viatra.query.runtime.matchers.util.Direction;
import org.eclipse.viatra.transformation.evm.api.Activation;
import org.eclipse.viatra.transformation.evm.api.ActivationLifeCycle;
import org.eclipse.viatra.transformation.evm.api.Context;
import org.eclipse.viatra.transformation.evm.api.ExecutionSchema;
import org.eclipse.viatra.transformation.evm.api.Job;
import org.eclipse.viatra.transformation.evm.api.RuleEngine;
import org.eclipse.viatra.transformation.evm.api.RuleSpecification;
import org.eclipse.viatra.transformation.evm.api.Scheduler;
import org.eclipse.viatra.transformation.evm.api.event.EventFilter;
import org.eclipse.viatra.transformation.evm.api.event.EventRealm;
import org.eclipse.viatra.transformation.evm.specific.ExecutionSchemas;
import org.eclipse.viatra.transformation.evm.specific.Jobs;
import org.eclipse.viatra.transformation.evm.specific.Lifecycles;
import org.eclipse.viatra.transformation.evm.specific.Rules;
import org.eclipse.viatra.transformation.evm.specific.Schedulers;
import org.eclipse.viatra.transformation.evm.specific.crud.CRUDActivationStateEnum;
import org.eclipse.viatra.transformation.evm.specific.event.ViatraQueryEventRealm;
import org.eclipse.viatra.transformation.evm.specific.job.SequentialProcessorsJob;

public final class ObservableCollectionHelper {
    private static ObservableCollectionHelper instance = new ObservableCollectionHelper();
    private Map<ViatraQueryEngine, WeakReference<RuleEngine>> queryToRuleEngineMap = new WeakHashMap<ViatraQueryEngine, WeakReference<RuleEngine>>();

    private static ObservableCollectionHelper getInstance() {
        return instance;
    }

    private ObservableCollectionHelper() {
    }

    protected static <Match extends IPatternMatch, Matcher extends ViatraQueryMatcher<Match>> RuleSpecification<Match> createRuleSpecification(IObservablePatternMatchCollectionUpdate<Match> observableCollectionUpdate, IQuerySpecification<Matcher> querySpecification) {
        Set<Job<Match>> jobs = ObservableCollectionHelper.getObservableCollectionJobs(observableCollectionUpdate);
        return Rules.newMatcherRuleSpecification(querySpecification, (ActivationLifeCycle)Lifecycles.getDefault((boolean)false, (boolean)true), jobs);
    }

    protected static <Match extends IPatternMatch, Matcher extends ViatraQueryMatcher<Match>> RuleSpecification<Match> createUpdatingRuleSpecification(IObservablePatternMatchCollectionUpdate<Match> observableCollectionUpdate, IQuerySpecification<Matcher> querySpecification) {
        Set<Job<Match>> jobs = ObservableCollectionHelper.getObservableCollectionJobs(observableCollectionUpdate);
        Job updateJob = Jobs.newErrorLoggingJob((Job)new SequentialProcessorsJob(CRUDActivationStateEnum.UPDATED, (List)ImmutableList.of(new ObservableCollectionProcessor<Match>(Direction.DELETE, observableCollectionUpdate), new ObservableCollectionProcessor<Match>(Direction.INSERT, observableCollectionUpdate))));
        ImmutableSet allJobs = ImmutableSet.builder().addAll(jobs).add((Object)updateJob).build();
        return Rules.newMatcherRuleSpecification(querySpecification, (ActivationLifeCycle)Lifecycles.getDefault((boolean)true, (boolean)true), (Set)allJobs);
    }

    protected static <Match extends IPatternMatch, Matcher extends ViatraQueryMatcher<Match>> RuleSpecification<Match> createRuleSpecification(IObservablePatternMatchCollectionUpdate<Match> observableCollectionUpdate, Matcher matcher) {
        Set<Job<Match>> jobs = ObservableCollectionHelper.getObservableCollectionJobs(observableCollectionUpdate);
        return Rules.newMatcherRuleSpecification(matcher, (ActivationLifeCycle)Lifecycles.getDefault((boolean)false, (boolean)true), jobs);
    }

    private static <Match extends IPatternMatch> Set<Job<Match>> getObservableCollectionJobs(IObservablePatternMatchCollectionUpdate<Match> observableCollectionUpdate) {
        Job insertJob = Jobs.newErrorLoggingJob((Job)Jobs.newStatelessJob((CRUDActivationStateEnum)CRUDActivationStateEnum.CREATED, new ObservableCollectionProcessor<Match>(Direction.INSERT, observableCollectionUpdate)));
        Job deleteJob = Jobs.newErrorLoggingJob((Job)Jobs.newStatelessJob((CRUDActivationStateEnum)CRUDActivationStateEnum.DELETED, new ObservableCollectionProcessor<Match>(Direction.DELETE, observableCollectionUpdate)));
        return ImmutableSet.of((Object)insertJob, (Object)deleteJob);
    }

    protected static <Match extends IPatternMatch> RuleEngine prepareRuleEngine(ViatraQueryEngine engine, RuleSpecification<Match> specification, EventFilter<Match> filter) {
        RuleEngine ruleEngine = ObservableCollectionHelper.getRuleEngine(engine);
        ruleEngine.addRule(specification, filter);
        ObservableCollectionHelper.fireActivations(ruleEngine, specification, filter);
        return ruleEngine;
    }

    protected static void disposeRuleEngine(RuleEngine ruleEngine) {
        Map<ViatraQueryEngine, WeakReference<RuleEngine>> ruleEngineMap = ObservableCollectionHelper.getInstance().getQueryToRuleEngineMap();
        EventRealm eventRealm = ruleEngine.getEventRealm();
        if (!(eventRealm instanceof ViatraQueryEventRealm)) {
            throw new IllegalArgumentException("Trying to dispose rule engine on realm different from ViatraQueryEventRealm!");
        }
        ViatraQueryEngine queryEngine = ((ViatraQueryEventRealm)eventRealm).getEngine();
        ruleEngineMap.remove(queryEngine);
        ruleEngine.dispose();
    }

    private static RuleEngine getRuleEngine(ViatraQueryEngine engine) {
        WeakReference<RuleEngine> ruleEngineRef;
        RuleEngine ruleEngine;
        Map<ViatraQueryEngine, WeakReference<RuleEngine>> ruleEngineMap = ObservableCollectionHelper.getInstance().getQueryToRuleEngineMap();
        if (ruleEngineMap.containsKey(engine) && (ruleEngine = (RuleEngine)(ruleEngineRef = ruleEngineMap.get(engine)).get()) != null) {
            return ruleEngine;
        }
        ExecutionSchema ruleEngine2 = ExecutionSchemas.createViatraQueryExecutionSchema((ViatraQueryEngine)engine, (Scheduler.ISchedulerFactory)Schedulers.getQueryEngineSchedulerFactory((ViatraQueryEngine)engine));
        ruleEngineMap.put(engine, new WeakReference<ExecutionSchema>(ruleEngine2));
        return ruleEngine2;
    }

    static <Match extends IPatternMatch> void fireActivations(RuleEngine ruleEngine, RuleSpecification<Match> specification, EventFilter<Match> filter) {
        Set activations = ruleEngine.getActivations(specification, filter);
        Context context = Context.create();
        for (Activation activation : activations) {
            activation.fire(context);
        }
    }

    private Map<ViatraQueryEngine, WeakReference<RuleEngine>> getQueryToRuleEngineMap() {
        return this.queryToRuleEngineMap;
    }
}

