/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.examples.cps.application.ui.transformationview;

import com.google.common.collect.Iterables;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobFunction;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.IdentityCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.viatra.examples.cps.application.ui.CPSApplicationUIPlugin;
import org.eclipse.viatra.examples.cps.application.ui.transformationview.EditorSelectionListener;
import org.eclipse.viatra.examples.cps.application.ui.transformationview.ITransformationRegistryListener;
import org.eclipse.viatra.examples.cps.application.ui.transformationview.TransformationRegistry;
import org.eclipse.viatra.examples.cps.application.ui.transformationview.TransformationSelectionControl;
import org.eclipse.viatra.examples.cps.application.ui.transformationview.util.TransformationConnector;
import org.eclipse.viatra.examples.cps.traceability.CPSToDeployment;
import org.eclipse.viatra.examples.cps.xform.m2m.launcher.CPSTransformationWrapper;
import org.eclipse.viatra.examples.cps.xform.m2m.launcher.CPSViatraTransformationWrapper;
import org.eclipse.viatra.examples.cps.xform.m2m.launcher.TransformationType;
import org.eclipse.viatra.query.runtime.api.IModelConnectorTypeEnum;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.IModelConnector;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.adapters.AdapterUtil;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.adapters.EMFModelConnector;
import org.eclipse.viatra.query.tooling.ui.util.IModelConnectorListener;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class TransformationManagerView
extends ViewPart {
    public static final String ID = "org.eclipse.viatra.examples.cps.xform.m2m.ui.ManageTransformationsView";
    private ListViewer listViewer;
    private final TransformationSelectionControl transformationSelectionControl = new TransformationSelectionControl();
    private Action runTransformAction;
    private Action runTransformWDebuggerAction;
    private Action stopTransformationAction;
    private EditorSelectionListener selectionHandler;
    private final ITransformationRegistryListener transformationsToListViewerListener = new ITransformationRegistryListener(){

        @Override
        public void transformationRemoved(TransformationConnector connector) {
            TransformationManagerView.this.listViewer.remove((Object)connector);
        }

        @Override
        public void transformationAdded(TransformationConnector connector) {
            TransformationManagerView.this.listViewer.add((Object)connector);
        }

        @Override
        public void transformationTypeChanged(TransformationType newTransformationType) {
            TransformationManagerView.this.isDebuggable = newTransformationType.isDebuggable();
            TransformationManagerView.this.refreshTransformationEnabled();
        }
    };
    private boolean transformationEnabled = false;
    private boolean isDebuggable = false;

    public void createPartControl(Composite parent) {
        boolean _tripleNotEquals;
        ListViewer _doubleArrow;
        ListViewer _listViewer = new ListViewer(parent);
        Procedures.Procedure1 _function = it -> {
            ISelectionChangedListener _function_1 = it_1 -> {
                ISelection selection = it_1.getSelection();
                if (selection instanceof IStructuredSelection) {
                    Iterable _function_2;
                    Iterable iterable = _function_2 = () -> ((IStructuredSelection)selection).iterator();
                    boolean enabled = ((IStructuredSelection)selection).size() >= 1 && IterableExtensions.forall(iterable, it_2 -> it_2 instanceof TransformationConnector);
                    this.stopTransformationAction.setEnabled(enabled);
                }
            };
            it.addSelectionChangedListener(_function_1);
            IDoubleClickListener _function_2 = it_1 -> {
                ISelection selection = it_1.getSelection();
                if (selection instanceof IStructuredSelection) {
                    boolean _tripleNotEquals;
                    int _size = ((IStructuredSelection)selection).size();
                    boolean bl = _tripleNotEquals = _size != 1;
                    if (_tripleNotEquals) {
                        return;
                    }
                    Object firstElement = ((IStructuredSelection)selection).getFirstElement();
                    if (firstElement instanceof TransformationConnector) {
                        CPSToDeployment _tracemodel = ((TransformationConnector)firstElement).getTracemodel();
                        ((TransformationConnector)firstElement).getModelConnector().showLocation(new Object[]{_tracemodel});
                    }
                }
            };
            it.addDoubleClickListener(_function_2);
        };
        this.listViewer = _doubleArrow = (ListViewer)ObjectExtensions.operator_doubleArrow((Object)_listViewer, (Procedures.Procedure1)_function);
        TransformationRegistry.getInstance().addListener(this.transformationsToListViewerListener, true);
        this.createActions();
        this.initializeToolBar();
        IWorkbenchPartSite _site = this.getSite();
        boolean bl = _tripleNotEquals = _site != null;
        if (_tripleNotEquals) {
            EditorSelectionListener _editorSelectionListener;
            IWorkbenchPartSite _site_1 = this.getSite();
            _site_1.setSelectionProvider((ISelectionProvider)this.listViewer);
            this.selectionHandler = _editorSelectionListener = new EditorSelectionListener(this);
            IWorkbenchWindow _workbenchWindow = this.getSite().getWorkbenchWindow();
            IWorkbenchPage _activePage = null;
            if (_workbenchWindow != null) {
                _activePage = _workbenchWindow.getActivePage();
            }
            IEditorPart _activeEditor = null;
            if (_activePage != null) {
                _activeEditor = _activePage.getActiveEditor();
            }
            this.selectionHandler.init(_activeEditor);
            IWorkbenchWindow _workbenchWindow_1 = this.getSite().getWorkbenchWindow();
            Procedures.Procedure1 _function_1 = it -> {
                it.getPartService().addPartListener((IPartListener)this.selectionHandler);
                it.getSelectionService().addSelectionListener((ISelectionListener)this.selectionHandler);
            };
            ObjectExtensions.operator_doubleArrow((Object)_workbenchWindow_1, (Procedures.Procedure1)_function_1);
        }
    }

    private void createActions() {
        ImageRegistry imageRegistry = CPSApplicationUIPlugin.getDefault().getImageRegistry();
        this.runTransformAction = new Action("Run Transformation on CPS To Deployment"){

            public void run() {
                TransformationManagerView.this.runTransformation(false);
            }
        };
        Procedures.Procedure1 _function = it -> {
            it.setImageDescriptor(imageRegistry.getDescriptor("load_query"));
            it.setEnabled(false);
        };
        ObjectExtensions.operator_doubleArrow((Object)this.runTransformAction, (Procedures.Procedure1)_function);
        this.runTransformWDebuggerAction = new Action("Run Transformation on CPS To Deployment and Wait for Debugger"){

            public void run() {
                TransformationManagerView.this.runTransformation(true);
            }
        };
        Procedures.Procedure1 _function_1 = it -> {
            it.setImageDescriptor(imageRegistry.getDescriptor("load_xform_w_debugger"));
            it.setEnabled(false);
        };
        ObjectExtensions.operator_doubleArrow((Object)this.runTransformWDebuggerAction, (Procedures.Procedure1)_function_1);
        this.stopTransformationAction = new Action("Stop and Remove Transformation"){

            public void run() {
                Iterable _function;
                super.run();
                Iterable iterable = _function = () -> TransformationManagerView.this.listViewer.getStructuredSelection().iterator();
                for (Object connector : iterable) {
                    if (!(connector instanceof TransformationConnector)) continue;
                    ((TransformationConnector)connector).getModelConnector().unloadModel();
                }
                TransformationManagerView.this.selectionHandler.refreshState();
            }
        };
        Procedures.Procedure1 _function_2 = it -> {
            it.setImageDescriptor(imageRegistry.getDescriptor("stop"));
            it.setEnabled(false);
        };
        ObjectExtensions.operator_doubleArrow((Object)this.stopTransformationAction, (Procedures.Procedure1)_function_2);
    }

    private void initializeToolBar() {
        IViewSite _viewSite = this.getViewSite();
        IActionBars _actionBars = null;
        if (_viewSite != null) {
            _actionBars = _viewSite.getActionBars();
        }
        IToolBarManager _toolBarManager = _actionBars.getToolBarManager();
        Procedures.Procedure1 _function = it -> {
            it.add((IContributionItem)this.transformationSelectionControl);
            it.add((IAction)this.runTransformAction);
            it.add((IAction)this.runTransformWDebuggerAction);
            it.add((IAction)this.stopTransformationAction);
        };
        ObjectExtensions.operator_doubleArrow((Object)_toolBarManager, (Procedures.Procedure1)_function);
    }

    public void setTransformationEnabled(boolean enabled) {
        this.transformationEnabled = enabled;
        this.refreshTransformationEnabled();
    }

    private void refreshTransformationEnabled() {
        if (this.runTransformAction == null) {
            return;
        }
        this.runTransformAction.setEnabled(this.transformationEnabled);
        this.runTransformWDebuggerAction.setEnabled(this.transformationEnabled && this.isDebuggable);
    }

    public void setFocus() {
        this.listViewer.getControl().setFocus();
    }

    public void dispose() {
        TransformationRegistry.getInstance().removeListener(this.transformationsToListViewerListener);
        IWorkbenchPartSite _site = this.getSite();
        IWorkbenchWindow _workbenchWindow = null;
        if (_site != null) {
            _workbenchWindow = _site.getWorkbenchWindow();
        }
        Procedures.Procedure1 _function = it -> {
            it.getPartService().removePartListener((IPartListener)this.selectionHandler);
            it.getSelectionService().removeSelectionListener((ISelectionListener)this.selectionHandler);
        };
        ObjectExtensions.operator_doubleArrow((Object)_workbenchWindow, (Procedures.Procedure1)_function);
        super.dispose();
    }

    public void runTransformation(boolean isDebugPressed) {
        CPSTransformationWrapper wrapper = null;
        try {
            boolean _not;
            IEditorPart editorPart;
            IWorkbenchPartSite _site = this.getSite();
            IWorkbenchPage _page = null;
            if (_site != null) {
                _page = _site.getPage();
            }
            IEditorPart _activeEditor = null;
            if (_page != null) {
                _activeEditor = _page.getActiveEditor();
            }
            if ((editorPart = _activeEditor) == null) {
                return;
            }
            boolean _containsKey = TransformationRegistry.getInstance().containsKey(editorPart);
            boolean bl = _not = !_containsKey;
            if (_not) {
                TransformationType transformationType = TransformationRegistry.getInstance().getNewTransformationType();
                wrapper = transformationType.getWrapper();
                IModelConnector _modelConnectorFromIEditorPart = AdapterUtil.getModelConnectorFromIEditorPart((IEditorPart)editorPart);
                EMFModelConnector modelConnector = (EMFModelConnector)_modelConnectorFromIEditorPart;
                modelConnector.loadModel(IModelConnectorTypeEnum.RESOURCESET);
                EObject _onlyElement = (EObject)Iterables.getOnlyElement((Iterable)modelConnector.getSelectedEObjects());
                CPSToDeployment tracemodel = (CPSToDeployment)_onlyElement;
                final TransformationConnector transformationConnector = new TransformationConnector(transformationType, wrapper, modelConnector, tracemodel);
                modelConnector.addListener(new IModelConnectorListener(){

                    public void modelUnloaded(IModelConnector it) {
                        EMFModelConnector modelConnector = transformationConnector.getModelConnector();
                        modelConnector.removeListener((IModelConnectorListener)this);
                        IWorkbenchPart _owner = modelConnector.getOwner();
                        IEditorPart editorPart = (IEditorPart)_owner;
                        transformationConnector.getWrapper().cleanupTransformation();
                        TransformationRegistry.getInstance().remove(editorPart);
                    }
                });
                TransformationRegistry.getInstance().put(editorPart, transformationConnector);
                boolean _matched = false;
                if (editorPart instanceof IEditingDomainProvider) {
                    _matched = true;
                    ((IEditingDomainProvider)editorPart).getEditingDomain().getCommandStack().execute((Command)IdentityCommand.INSTANCE);
                }
                String _xifexpression = null;
                _xifexpression = isDebugPressed ? "Running CPS Transformation. Connect Debugger!" : "Running CPS Transformation";
                String jobName = _xifexpression;
                CPSTransformationWrapper wrapperVal = wrapper;
                IJobFunction _function = it -> {
                    try {
                        boolean _not_1;
                        if (isDebugPressed) {
                            ((CPSViatraTransformationWrapper)wrapperVal).initializeDebuggableTransformation(tracemodel);
                        } else {
                            wrapperVal.initializeTransformation(tracemodel);
                        }
                        wrapperVal.executeTransformation();
                        boolean _isIncremental = transformationType.getWrapper().isIncremental();
                        boolean bl2 = _not_1 = !_isIncremental;
                        if (_not_1) {
                            Runnable _function_1 = () -> modelConnector.unloadModel();
                            Display.getDefault().syncExec(_function_1);
                        }
                        return Status.OK_STATUS;
                    }
                    catch (Throwable _t) {
                        if (_t instanceof Exception) {
                            Exception e = (Exception)_t;
                            wrapperVal.cleanupTransformation();
                            Runnable _function_2 = () -> modelConnector.unloadModel();
                            Display.getDefault().syncExec(_function_2);
                            return new Status(4, "org.eclipse.viatra.examples.cps.application.ui", "Error running transformation", (Throwable)e);
                        }
                        throw Exceptions.sneakyThrow((Throwable)_t);
                    }
                };
                Job.create((String)jobName, (IJobFunction)_function).schedule();
            }
            this.selectionHandler.refreshState();
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception e = (Exception)_t;
                if (wrapper != null) {
                    wrapper.cleanupTransformation();
                }
                IWorkbenchPartSite _site_1 = this.getSite();
                Shell _shell = null;
                if (_site_1 != null) {
                    _shell = _site_1.getShell();
                }
                MessageDialog.openError((Shell)_shell, (String)"Error running transformation", (String)e.getMessage());
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }
}

