/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.examples.cps.xform.m2m.batch.viatra;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.CyberPhysicalSystem;
import org.eclipse.viatra.examples.cps.deployment.Deployment;
import org.eclipse.viatra.examples.cps.traceability.CPSToDeployment;
import org.eclipse.viatra.examples.cps.xform.m2m.batch.viatra.patterns.CpsXformM2M;
import org.eclipse.viatra.examples.cps.xform.m2m.batch.viatra.rules.RuleProvider;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.transformation.debug.configuration.TransformationDebuggerConfiguration;
import org.eclipse.viatra.transformation.evm.api.adapter.IAdapterConfiguration;
import org.eclipse.viatra.transformation.runtime.emf.transformation.batch.BatchTransformation;
import org.eclipse.viatra.transformation.runtime.emf.transformation.batch.BatchTransformationStatements;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;

public class CPS2DeploymentBatchViatra {
    @Extension
    private Logger logger = Logger.getLogger((String)"cps.xform.m2m.batch.viatra");
    @Extension
    private CpsXformM2M cpsXformM2M = CpsXformM2M.instance();
    @Extension
    private RuleProvider ruleProvider;
    @Extension
    private BatchTransformation transformation;
    @Extension
    private BatchTransformationStatements statements;
    private CPSToDeployment mapping;
    private ViatraQueryEngine engine;
    private boolean initialized = false;

    public boolean initialize(CPSToDeployment cps2dep, ViatraQueryEngine engine) {
        return this.initialize(cps2dep, engine, false, null);
    }

    public boolean initialize(CPSToDeployment cps2dep, ViatraQueryEngine engine, boolean isDebuggable, String debugName) {
        boolean _xblockexpression = false;
        Preconditions.checkArgument((cps2dep != null ? 1 : 0) != 0, (Object)"Mapping cannot be null!");
        CyberPhysicalSystem _cps = cps2dep.getCps();
        boolean _tripleNotEquals = _cps != null;
        Preconditions.checkArgument((boolean)_tripleNotEquals, (Object)"CPS not defined in mapping!");
        Deployment _deployment = cps2dep.getDeployment();
        boolean _tripleNotEquals_1 = _deployment != null;
        Preconditions.checkArgument((boolean)_tripleNotEquals_1, (Object)"Deployment not defined in mapping!");
        Preconditions.checkArgument((engine != null ? 1 : 0) != 0, (Object)"Engine cannot be null!");
        boolean _xifexpression = false;
        if (!this.initialized) {
            RuleProvider _ruleProvider;
            boolean _xblockexpression_1 = false;
            this.mapping = cps2dep;
            this.engine = engine;
            this.ruleProvider = _ruleProvider = new RuleProvider(engine, cps2dep);
            BatchTransformation.BatchTransformationBuilder transformationBuilder = BatchTransformation.forEngine((ViatraQueryEngine)engine);
            if (isDebuggable) {
                String _elvis = null;
                _elvis = debugName != null ? debugName : "CPS2DeploymentBatchViatra";
                TransformationDebuggerConfiguration debuggerConfig = new TransformationDebuggerConfiguration(_elvis);
                transformationBuilder.addAdapterConfiguration((IAdapterConfiguration)debuggerConfig);
            }
            this.transformation = transformationBuilder.build();
            this.statements = this.transformation.getTransformationStatements();
            this.logger.debug((Object)"Preparing queries on engine.");
            Stopwatch watch = Stopwatch.createStarted();
            this.cpsXformM2M.prepare(engine);
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Prepared queries on engine (");
            long _elapsed = watch.elapsed(TimeUnit.MILLISECONDS);
            _builder.append((Object)_elapsed);
            _builder.append(" ms");
            this.logger.debug((Object)_builder);
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("Preparing transformation rules.");
            this.logger.debug((Object)_builder_1);
            watch = Stopwatch.createStarted();
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append("Prepared transformation rules (");
            long _elapsed_1 = watch.elapsed(TimeUnit.MILLISECONDS);
            _builder_2.append((Object)_elapsed_1);
            _builder_2.append(" ms)");
            this.logger.debug((Object)_builder_2);
            this.initialized = true;
            _xifexpression = _xblockexpression_1 = true;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public void execute() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Executing transformation on: Cyber-physical system: ");
        String _identifier = this.mapping.getCps().getIdentifier();
        _builder.append(_identifier);
        this.logger.debug((Object)_builder);
        this.mapping.getTraces().clear();
        this.mapping.getDeployment().getHosts().clear();
        this.statements.fireAllCurrent(this.ruleProvider.getHostRule());
        this.statements.fireAllCurrent(this.ruleProvider.getApplicationRule());
        this.statements.fireAllCurrent(this.ruleProvider.getStateMachineRule());
        this.statements.fireAllCurrent(this.ruleProvider.getStateRule());
        this.statements.fireAllCurrent(this.ruleProvider.getTransitionRule());
        this.statements.fireAllCurrent(this.ruleProvider.getActionRule());
    }

    public void dispose() {
        if (this.transformation != null) {
            this.transformation.getRuleEngine().dispose();
        }
        this.transformation = null;
    }
}

