/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.examples.cps.xform.m2m.incr.qrt.rules;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.Identifiable;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.State;
import org.eclipse.viatra.examples.cps.deployment.BehaviorState;
import org.eclipse.viatra.examples.cps.deployment.DeploymentApplication;
import org.eclipse.viatra.examples.cps.deployment.DeploymentBehavior;
import org.eclipse.viatra.examples.cps.deployment.DeploymentElement;
import org.eclipse.viatra.examples.cps.traceability.CPS2DeploymentTrace;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.qrt.queries.StateMatch;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.qrt.rules.AbstractRule;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.qrt.util.PriorityRuleSpecification;
import org.eclipse.viatra.query.runtime.api.IMatchProcessor;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.transformation.evm.api.ActivationLifeCycle;
import org.eclipse.viatra.transformation.evm.api.Job;
import org.eclipse.viatra.transformation.evm.specific.Jobs;
import org.eclipse.viatra.transformation.evm.specific.Lifecycles;
import org.eclipse.viatra.transformation.evm.specific.Rules;
import org.eclipse.viatra.transformation.evm.specific.crud.CRUDActivationStateEnum;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class StateMapping
extends AbstractRule<StateMatch> {
    public StateMapping(ViatraQueryEngine engine) {
        super(engine);
    }

    @Override
    public PriorityRuleSpecification<StateMatch> getSpecification() {
        PriorityRuleSpecification _createPriorityRuleSpecification = this.createPriorityRuleSpecification();
        Procedures.Procedure1 _function = it -> {
            Job<StateMatch> _appearedJob = this.getAppearedJob();
            Job<StateMatch> _updateJob = this.getUpdateJob();
            Job<StateMatch> _disappearedJob = this.getDisappearedJob();
            it.setRuleSpecification(Rules.newMatcherRuleSpecification((IQuerySpecification)this.cpsXformM2M.getState(), (ActivationLifeCycle)Lifecycles.getDefault((boolean)true, (boolean)true), Collections.unmodifiableSet(CollectionLiterals.newHashSet((Object[])new Job[]{_appearedJob, _updateJob, _disappearedJob}))));
            it.setPriority(4);
        };
        return (PriorityRuleSpecification)ObjectExtensions.operator_doubleArrow(_createPriorityRuleSpecification, (Procedures.Procedure1)_function);
    }

    private Job<StateMatch> getAppearedJob() {
        IMatchProcessor _function = match -> {
            Set<CPS2DeploymentTrace> traces;
            boolean _isEmpty;
            DeploymentElement _head = (DeploymentElement)IterableExtensions.head(this.cpsXformM2M.getCps2depTrace(this.engine).getAllValuesOfdepElement(null, null, (Identifiable)match.getAppInstance()));
            DeploymentApplication depApp = (DeploymentApplication)_head;
            DeploymentBehavior depBehavior = depApp.getBehavior();
            State state = match.getState();
            String stateId = state.getIdentifier();
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Mapping state with ID: ");
            _builder.append(stateId);
            this.logger.debug((Object)_builder);
            BehaviorState _createBehaviorState = this.depFactory.createBehaviorState();
            Procedures.Procedure1 _function_1 = it -> it.setDescription(stateId);
            BehaviorState depState = (BehaviorState)ObjectExtensions.operator_doubleArrow((Object)_createBehaviorState, (Procedures.Procedure1)_function_1);
            EList _states = depBehavior.getStates();
            _states.add((Object)depState);
            State _initial = match.getStateMachine().getInitial();
            boolean _equals = Objects.equal((Object)_initial, (Object)state);
            if (_equals) {
                depBehavior.setCurrent(depState);
            }
            if (_isEmpty = (traces = this.cpsXformM2M.getCps2depTrace(this.engine).getAllValuesOftrace(null, (Identifiable)state, null)).isEmpty()) {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("Creating new trace for state ");
                this.logger.trace((Object)_builder_1);
                EList _traces = this.getRootMapping().getTraces();
                CPS2DeploymentTrace _createCPS2DeploymentTrace = this.traceFactory.createCPS2DeploymentTrace();
                Procedures.Procedure1 _function_2 = it -> {
                    EList _cpsElements = it.getCpsElements();
                    _cpsElements.add((Object)state);
                    EList _deploymentElements = it.getDeploymentElements();
                    _deploymentElements.add((Object)depState);
                };
                CPS2DeploymentTrace _doubleArrow = (CPS2DeploymentTrace)ObjectExtensions.operator_doubleArrow((Object)_createCPS2DeploymentTrace, (Procedures.Procedure1)_function_2);
                _traces.add((Object)_doubleArrow);
            } else {
                StringConcatenation _builder_2 = new StringConcatenation();
                _builder_2.append("Adding new state to existing trace");
                this.logger.trace((Object)_builder_2);
                EList _deploymentElements = ((CPS2DeploymentTrace)IterableExtensions.head(traces)).getDeploymentElements();
                _deploymentElements.add((Object)depState);
            }
            StringConcatenation _builder_3 = new StringConcatenation();
            _builder_3.append("Mapped state with ID: ");
            _builder_3.append(stateId);
            this.logger.debug((Object)_builder_3);
        };
        return Jobs.newStatelessJob((CRUDActivationStateEnum)CRUDActivationStateEnum.CREATED, (IMatchProcessor)_function);
    }

    private Job<StateMatch> getUpdateJob() {
        IMatchProcessor _function = match -> {
            State initState;
            boolean _equals;
            boolean _notEquals;
            State state = match.getState();
            String stateId = state.getIdentifier();
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Updating mapped state with ID: ");
            _builder.append(stateId);
            this.logger.debug((Object)_builder);
            DeploymentApplication depApp = (DeploymentApplication)IterableExtensions.head((Iterable)Iterables.filter(this.cpsXformM2M.getCps2depTrace(this.engine).getAllValuesOfdepElement(null, null, (Identifiable)match.getAppInstance()), DeploymentApplication.class));
            Functions.Function1 _function_1 = it -> depApp.getBehavior().getStates().contains(it);
            BehaviorState depState = (BehaviorState)IterableExtensions.findFirst((Iterable)Iterables.filter(this.cpsXformM2M.getCps2depTrace(this.engine).getAllValuesOfdepElement(null, null, (Identifiable)match.getState()), BehaviorState.class), (Functions.Function1)_function_1);
            DeploymentBehavior depBehavior = depApp.getBehavior();
            String oldDesc = depState.getDescription();
            boolean bl = _notEquals = !Objects.equal((Object)oldDesc, (Object)stateId);
            if (_notEquals) {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("ID changed to ");
                _builder_1.append(stateId);
                this.logger.trace((Object)_builder_1);
                depState.setDescription(stateId);
            }
            if (_equals = Objects.equal((Object)state, (Object)(initState = match.getStateMachine().getInitial()))) {
                boolean _notEquals_1;
                BehaviorState currentState = depBehavior.getCurrent();
                boolean bl2 = _notEquals_1 = !Objects.equal((Object)currentState, (Object)depState);
                if (_notEquals_1) {
                    StringConcatenation _builder_2 = new StringConcatenation();
                    _builder_2.append("Current state changed to ");
                    _builder_2.append(stateId);
                    this.logger.trace((Object)_builder_2);
                    depBehavior.setCurrent(depState);
                }
            }
            StringConcatenation _builder_3 = new StringConcatenation();
            _builder_3.append("Updated mapped state with ID: ");
            _builder_3.append(stateId);
            this.logger.debug((Object)_builder_3);
        };
        return Jobs.newStatelessJob((CRUDActivationStateEnum)CRUDActivationStateEnum.UPDATED, (IMatchProcessor)_function);
    }

    private Job<StateMatch> getDisappearedJob() {
        IMatchProcessor _function = match -> {
            DeploymentElement _head = (DeploymentElement)IterableExtensions.head(this.cpsXformM2M.getCps2depTrace(this.engine).getAllValuesOfdepElement(null, null, (Identifiable)match.getAppInstance()));
            DeploymentApplication depApp = (DeploymentApplication)_head;
            DeploymentBehavior depBehavior = depApp.getBehavior();
            Functions.Function1 _function_1 = it -> depApp.getBehavior().getStates().contains(it);
            BehaviorState depState = (BehaviorState)IterableExtensions.findFirst((Iterable)Iterables.filter(this.cpsXformM2M.getCps2depTrace(this.engine).getAllValuesOfdepElement(null, null, (Identifiable)match.getState()), BehaviorState.class), (Functions.Function1)_function_1);
            String stateId = depState.getDescription();
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Removing state with ID: ");
            _builder.append(stateId);
            this.logger.debug((Object)_builder);
            if (depBehavior != null) {
                EList _states = depBehavior.getStates();
                _states.remove((Object)depState);
                BehaviorState _current = depBehavior.getCurrent();
                boolean _equals = Objects.equal((Object)_current, (Object)depState);
                if (_equals) {
                    depBehavior.setCurrent(null);
                }
            }
            CPS2DeploymentTrace smTrace = (CPS2DeploymentTrace)IterableExtensions.head(this.cpsXformM2M.getCps2depTrace(this.engine).getAllValuesOftrace(null, (Identifiable)match.getState(), null));
            EList _deploymentElements = smTrace.getDeploymentElements();
            _deploymentElements.remove((Object)depState);
            boolean _isEmpty = smTrace.getDeploymentElements().isEmpty();
            if (_isEmpty) {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("Removing empty trace");
                this.logger.trace((Object)_builder_1);
                EList _traces = this.getRootMapping().getTraces();
                _traces.remove((Object)smTrace);
            }
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append("Removed state with ID: ");
            _builder_2.append(stateId);
            this.logger.debug((Object)_builder_2);
        };
        return Jobs.newStatelessJob((CRUDActivationStateEnum)CRUDActivationStateEnum.DELETED, (IMatchProcessor)_function);
    }
}

