/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.base.itc.alg.counting;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.viatra.query.runtime.base.itc.alg.misc.ITcRelation;
import org.eclipse.viatra.query.runtime.base.itc.alg.misc.topsort.TopologicalSorting;
import org.eclipse.viatra.query.runtime.base.itc.igraph.IBiDirectionalGraphDataSource;
import org.eclipse.viatra.query.runtime.matchers.util.CollectionsFactory;
import org.eclipse.viatra.query.runtime.matchers.util.IMultiset;

public class CountingTcRelation<V>
implements ITcRelation<V> {
    private Map<V, IMultiset<V>> tuplesForward = CollectionsFactory.createMap();
    private Map<V, IMultiset<V>> tuplesBackward = null;

    protected CountingTcRelation(boolean backwardIndexing) {
        if (backwardIndexing) {
            this.tuplesBackward = CollectionsFactory.createMap();
        }
    }

    protected boolean isEmpty() {
        return this.tuplesForward.isEmpty();
    }

    protected void clear() {
        this.tuplesForward.clear();
        if (this.tuplesBackward != null) {
            this.tuplesBackward.clear();
        }
    }

    protected void union(CountingTcRelation<V> rA) {
        for (Map.Entry<V, IMultiset<V>> entry : rA.tuplesForward.entrySet()) {
            V source = entry.getKey();
            IMultiset<V> targetBag = entry.getValue();
            for (Object target : targetBag.keySet()) {
                this.addTuple(source, target, targetBag.getCount(target));
            }
        }
    }

    public int getCount(V source, V target) {
        if (this.tuplesForward.containsKey(source) && this.tuplesForward.get(source).containsNonZero(target)) {
            return this.tuplesForward.get(source).getCount(target);
        }
        return 0;
    }

    public boolean addTuple(V source, V target, int count) {
        IMultiset sMap = null;
        IMultiset tMap = null;
        if (this.tuplesBackward != null) {
            tMap = this.tuplesBackward.get(target);
            if (tMap == null) {
                sMap = CollectionsFactory.createMultiset();
                sMap.addPositive(source, count);
                this.tuplesBackward.put((IMultiset)target, (IMultiset<IMultiset>)sMap);
            } else {
                tMap.addPositive(source, count);
            }
        }
        if ((sMap = this.tuplesForward.get(source)) == null) {
            tMap = CollectionsFactory.createMultiset();
            tMap.addPositive(target, count);
            this.tuplesForward.put((IMultiset)source, (IMultiset<IMultiset>)tMap);
            return true;
        }
        boolean newTarget = sMap.addPositive(target, count);
        return newTarget;
    }

    public boolean updateTuple(V source, V target, boolean isInsertion) {
        IMultiset sMap = null;
        IMultiset tMap = null;
        if (this.tuplesBackward != null) {
            tMap = this.tuplesBackward.get(target);
            if (tMap == null) {
                tMap = CollectionsFactory.createMultiset();
                if (isInsertion) {
                    tMap.addOne(source);
                } else {
                    tMap.removeOne(source);
                }
                this.tuplesBackward.put((IMultiset)target, (IMultiset<IMultiset>)tMap);
            } else if (isInsertion) {
                tMap.addOne(source);
            } else if (tMap.removeOne(source) && tMap.isEmpty()) {
                this.tuplesBackward.remove(target);
            }
        }
        if ((sMap = this.tuplesForward.get(source)) == null) {
            sMap = CollectionsFactory.createMultiset();
            if (isInsertion) {
                sMap.addOne(target);
            } else {
                sMap.removeOne(target);
            }
            this.tuplesForward.put((IMultiset)source, (IMultiset<IMultiset>)sMap);
            return true;
        }
        if (isInsertion) {
            return sMap.addOne(target);
        }
        boolean last = sMap.removeOne(target);
        if (last && sMap.isEmpty()) {
            this.tuplesForward.remove(source);
        }
        return last;
    }

    public void deleteTupleEnd(V tupleEnd) {
        IMultiset<V> pairs;
        Set tmp;
        this.tuplesForward.remove(tupleEnd);
        if (this.tuplesForward.keySet() != null) {
            tmp = CollectionsFactory.createSet(this.tuplesForward.keySet());
            for (Object key : tmp) {
                pairs = this.tuplesForward.get(key);
                pairs.clearAllOf(tupleEnd);
                if (!pairs.isEmpty()) continue;
                this.tuplesForward.remove(key);
            }
        }
        if (this.tuplesBackward != null) {
            this.tuplesBackward.remove(tupleEnd);
            if (this.tuplesBackward.keySet() != null) {
                tmp = CollectionsFactory.createSet(this.tuplesBackward.keySet());
                for (Object key : tmp) {
                    pairs = this.tuplesBackward.get(key);
                    pairs.clearAllOf(tupleEnd);
                    if (!pairs.isEmpty()) continue;
                    this.tuplesBackward.remove(key);
                }
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TcRelation = ");
        for (Map.Entry<V, IMultiset<V>> outerEntry : this.tuplesForward.entrySet()) {
            V source = outerEntry.getKey();
            IMultiset<V> targets = outerEntry.getValue();
            for (Object target : targets.keySet()) {
                sb.append("{(" + source + "," + target + ")," + targets.getCount(target) + "} ");
            }
        }
        return sb.toString();
    }

    @Override
    public Set<V> getTupleEnds(V source) {
        IMultiset<V> tupEnds = this.tuplesForward.get(source);
        if (tupEnds == null) {
            return null;
        }
        return tupEnds.keySet();
    }

    public Set<V> getTupleStarts(V target) {
        if (this.tuplesBackward != null) {
            IMultiset<V> tupStarts = this.tuplesBackward.get(target);
            if (tupStarts == null) {
                return null;
            }
            return tupStarts.keySet();
        }
        return null;
    }

    @Override
    public Set<V> getTupleStarts() {
        Set nodes = CollectionsFactory.createSet(this.tuplesForward.keySet());
        return nodes;
    }

    public boolean containsTuple(V source, V target) {
        return this.tuplesForward.containsKey(source) && this.tuplesForward.get(source).containsNonZero(target);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CountingTcRelation aTR = (CountingTcRelation)obj;
        return this.tuplesForward.equals(aTR.tuplesForward);
    }

    public int hashCode() {
        return this.tuplesForward.hashCode();
    }

    public static <V> CountingTcRelation<V> createFrom(IBiDirectionalGraphDataSource<V> gds) {
        List<V> topologicalSorting = TopologicalSorting.compute(gds);
        CountingTcRelation<V> tc = new CountingTcRelation<V>(true);
        Collections.reverse(topologicalSorting);
        for (V n : topologicalSorting) {
            Map<V, Integer> sourceNodes = gds.getSourceNodes(n);
            Set<V> tupEnds = tc.getTupleEnds(n);
            for (Map.Entry<V, Integer> entry : sourceNodes.entrySet()) {
                int i = 0;
                while (i < entry.getValue()) {
                    V s = entry.getKey();
                    tc.updateTuple(s, n, true);
                    if (tupEnds != null) {
                        for (V t : tupEnds) {
                            tc.updateTuple(s, t, true);
                        }
                    }
                    ++i;
                }
            }
        }
        return tc;
    }
}

