/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.operations.generic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.viatra.query.runtime.localsearch.MatchingFrame;
import org.eclipse.viatra.query.runtime.localsearch.matcher.ISearchContext;
import org.eclipse.viatra.query.runtime.localsearch.operations.IIteratingSearchOperation;
import org.eclipse.viatra.query.runtime.localsearch.operations.check.CheckOperation;
import org.eclipse.viatra.query.runtime.matchers.context.IInputKey;
import org.eclipse.viatra.query.runtime.matchers.tuple.ITuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask;
import org.eclipse.viatra.query.runtime.matchers.tuple.VolatileMaskedTuple;
import org.eclipse.viatra.query.runtime.matchers.util.Preconditions;

public class GenericTypeCheck
extends CheckOperation
implements IIteratingSearchOperation {
    private final IInputKey type;
    private final List<Integer> positionList;
    private VolatileMaskedTuple maskedTuple;

    public GenericTypeCheck(IInputKey type, int[] positions, TupleMask callMask) {
        Preconditions.checkArgument((positions.length == type.getArity() ? 1 : 0) != 0, (String)"The type %s requires %d parameters, but %d positions are provided", (Object[])new Object[]{type.getPrettyPrintableName(), type.getArity(), positions.length});
        ArrayList<Integer> modifiablePositionList = new ArrayList<Integer>();
        int[] nArray = positions;
        int n = positions.length;
        int n2 = 0;
        while (n2 < n) {
            int position = nArray[n2];
            modifiablePositionList.add(position);
            ++n2;
        }
        this.positionList = Collections.unmodifiableList(modifiablePositionList);
        this.maskedTuple = new VolatileMaskedTuple(callMask);
        this.type = type;
    }

    @Override
    public List<Integer> getVariablePositions() {
        return this.positionList;
    }

    @Override
    protected boolean check(MatchingFrame frame, ISearchContext context) {
        this.maskedTuple.updateTuple((ITuple)frame);
        return context.getRuntimeContext().containsTuple(this.type, (ITuple)this.maskedTuple);
    }

    public String toString() {
        return "check     " + this.type.getPrettyPrintableName() + "(" + this.positionList.stream().map(input -> String.format("+%d", input)).collect(Collectors.joining(", ")) + ")";
    }

    @Override
    public IInputKey getIteratedInputKey() {
        return this.type;
    }
}

