/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.operations.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.viatra.query.runtime.localsearch.matcher.MatcherReference;
import org.eclipse.viatra.query.runtime.matchers.psystem.PVariable;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.PatternCallBasedDeferred;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicenumerables.BinaryTransitiveClosure;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicenumerables.PositivePatternCall;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PQuery;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask;

public final class CallInformation {
    private final TupleMask fullFrameMask;
    private final TupleMask thinFrameMask;
    private final TupleMask parameterMask;
    private final int[] freeParameterIndices;
    private final Map<PParameter, Integer> mapping = new HashMap<PParameter, Integer>();
    private final Set<PParameter> adornment = new HashSet<PParameter>();
    private final PQuery referredQuery;
    private final MatcherReference matcherReference;

    public static CallInformation create(PatternCallBasedDeferred constraint, Map<PVariable, Integer> variableMapping, Set<Integer> bindings) {
        return new CallInformation(constraint.getActualParametersTuple(), constraint.getReferredQuery(), bindings, variableMapping);
    }

    public static CallInformation create(PositivePatternCall pCall, Map<PVariable, Integer> variableMapping, Set<Integer> bindings) {
        return new CallInformation(pCall.getVariablesTuple(), pCall.getReferredQuery(), bindings, variableMapping);
    }

    public static CallInformation create(BinaryTransitiveClosure constraint, Map<PVariable, Integer> variableMapping, Set<Integer> bindings) {
        return new CallInformation(constraint.getVariablesTuple(), constraint.getReferredQuery(), bindings, variableMapping);
    }

    private CallInformation(Tuple actualParameters, PQuery referredQuery, Set<Integer> bindings, Map<PVariable, Integer> variableMapping) {
        this.referredQuery = referredQuery;
        int keySize = actualParameters.getSize();
        ArrayList<Integer> parameterMaskIndices = new ArrayList<Integer>();
        int[] fullParameterMaskIndices = new int[keySize];
        int i = 0;
        while (i < keySize) {
            PParameter symbolicParameter = (PParameter)referredQuery.getParameters().get(i);
            PVariable parameter = (PVariable)actualParameters.get(i);
            Integer originalFrameIndex = variableMapping.get(parameter);
            this.mapping.put(symbolicParameter, originalFrameIndex);
            fullParameterMaskIndices[i] = originalFrameIndex;
            if (bindings.contains(originalFrameIndex)) {
                parameterMaskIndices.add(originalFrameIndex);
                this.adornment.add(symbolicParameter);
            }
            ++i;
        }
        this.thinFrameMask = TupleMask.fromSelectedIndices((int)variableMapping.size(), parameterMaskIndices);
        this.fullFrameMask = TupleMask.fromSelectedIndices((int)variableMapping.size(), (int[])fullParameterMaskIndices);
        int[] boundParameterIndices = new int[this.adornment.size()];
        int boundIndex = 0;
        this.freeParameterIndices = new int[keySize - this.adornment.size()];
        int freeIndex = 0;
        int i2 = 0;
        while (i2 < keySize) {
            if (bindings.contains(variableMapping.get(actualParameters.get(i2)))) {
                boundParameterIndices[boundIndex] = i2;
                ++boundIndex;
            } else {
                this.freeParameterIndices[freeIndex] = i2;
                ++freeIndex;
            }
            ++i2;
        }
        this.parameterMask = TupleMask.fromSelectedIndices((int)keySize, (int[])boundParameterIndices);
        this.matcherReference = new MatcherReference(referredQuery, this.adornment);
    }

    public TupleMask getThinFrameMask() {
        return this.thinFrameMask;
    }

    public TupleMask getFullFrameMask() {
        return this.fullFrameMask;
    }

    public TupleMask getParameterMask() {
        return this.parameterMask;
    }

    public MatcherReference getReference() {
        return this.matcherReference;
    }

    public int[] getFreeParameterIndices() {
        return this.freeParameterIndices;
    }

    public List<Integer> getVariablePositions() {
        ArrayList<Integer> variables = new ArrayList<Integer>(this.mapping.size());
        for (PParameter p : this.referredQuery.getParameters()) {
            variables.add(this.mapping.get(p));
        }
        return variables;
    }

    public String toString() {
        return String.valueOf(this.referredQuery.getFullyQualifiedName()) + "(" + this.referredQuery.getParameters().stream().map(input -> String.valueOf(this.adornment.contains(input) ? "+" : "-") + this.mapping.get(input)).collect(Collectors.joining(",")) + ")";
    }
}

