/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.tooling.ui.registry;

import com.google.common.collect.Lists;
import java.util.Collection;
import org.eclipse.viatra.query.runtime.localsearch.matcher.integration.LocalSearchBackendFactory;
import org.eclipse.viatra.query.runtime.matchers.backend.IQueryBackendFactory;
import org.eclipse.viatra.query.runtime.rete.matcher.ReteBackendFactory;

public class QueryBackendRegistry {
    private static final QueryBackendRegistry INSTANCE = new QueryBackendRegistry();
    private static final IQueryBackendFactory DEFAULT_BACKEND;
    private static final IQueryBackendFactory DEFAULT_CACHING_BACKEND;
    private static final IQueryBackendFactory LOCAL_SEARCH_BACKEND;
    private static Collection<IQueryBackendFactory> queryBackendFactories;

    static {
        DEFAULT_CACHING_BACKEND = DEFAULT_BACKEND = new ReteBackendFactory();
        LOCAL_SEARCH_BACKEND = LocalSearchBackendFactory.INSTANCE;
        queryBackendFactories = Lists.newArrayList((Object[])new IQueryBackendFactory[]{DEFAULT_BACKEND, LOCAL_SEARCH_BACKEND});
    }

    private QueryBackendRegistry() {
    }

    public static QueryBackendRegistry getInstance() {
        return INSTANCE;
    }

    public IQueryBackendFactory getDefaultBackend() {
        return DEFAULT_BACKEND;
    }

    public IQueryBackendFactory getDefaultCachingBackendClass() {
        return DEFAULT_CACHING_BACKEND;
    }

    public Iterable<IQueryBackendFactory> getAllKnownFactories() {
        return queryBackendFactories;
    }

    public String getQueryBackendName(IQueryBackendFactory backend) {
        return backend.getBackendClass().getSimpleName();
    }
}

