/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.transformation.runtime.emf.rules.eventdriven;

import java.util.HashSet;
import java.util.Map;
import org.eclipse.viatra.query.runtime.api.IMatchProcessor;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.api.ViatraQueryMatcher;
import org.eclipse.viatra.transformation.evm.api.ActivationLifeCycle;
import org.eclipse.viatra.transformation.evm.api.Job;
import org.eclipse.viatra.transformation.evm.api.RuleSpecification;
import org.eclipse.viatra.transformation.evm.api.event.EventFilter;
import org.eclipse.viatra.transformation.evm.specific.Jobs;
import org.eclipse.viatra.transformation.evm.specific.Rules;
import org.eclipse.viatra.transformation.evm.specific.crud.CRUDActivationStateEnum;
import org.eclipse.viatra.transformation.runtime.emf.rules.ITransformationRule;

public class EventDrivenTransformationRule<Match extends IPatternMatch, Matcher extends ViatraQueryMatcher<Match>>
implements ITransformationRule<Match, Matcher> {
    private final String name;
    private final IQuerySpecification<Matcher> precondition;
    private final RuleSpecification<Match> ruleSpecification;
    private final EventFilter<? super Match> filter;

    public EventDrivenTransformationRule(String name, IQuerySpecification<Matcher> precondition, Map<CRUDActivationStateEnum, IMatchProcessor<Match>> stateActions, ActivationLifeCycle lifeCycle, EventFilter<? super Match> filter) {
        this.name = name;
        HashSet<Job> jobs = new HashSet<Job>();
        for (Map.Entry<CRUDActivationStateEnum, IMatchProcessor<Match>> stateAction : stateActions.entrySet()) {
            CRUDActivationStateEnum state = stateAction.getKey();
            IMatchProcessor<Match> action = stateAction.getValue();
            jobs.add(Jobs.newStatelessJob((CRUDActivationStateEnum)state, action));
        }
        this.precondition = precondition;
        this.ruleSpecification = Rules.newMatcherRuleSpecification(precondition, (ActivationLifeCycle)lifeCycle, jobs, (String)name);
        this.filter = filter;
    }

    public EventDrivenTransformationRule(EventDrivenTransformationRule<Match, Matcher> rule, EventFilter<? super Match> filter) {
        this.name = rule.name;
        this.precondition = rule.precondition;
        this.ruleSpecification = rule.ruleSpecification;
        this.filter = filter;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public RuleSpecification<Match> getRuleSpecification() {
        return this.ruleSpecification;
    }

    @Override
    public IQuerySpecification<Matcher> getPrecondition() {
        return this.precondition;
    }

    @Override
    public EventFilter<? super Match> getFilter() {
        if (this.filter == null) {
            return this.ruleSpecification.createEmptyFilter();
        }
        return this.filter;
    }
}

