/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.operations.extend;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.eclipse.viatra.query.runtime.localsearch.MatchingFrame;
import org.eclipse.viatra.query.runtime.localsearch.matcher.ISearchContext;
import org.eclipse.viatra.query.runtime.localsearch.operations.ISearchOperation;
import org.eclipse.viatra.query.runtime.localsearch.operations.extend.SingleValueExtendOperationExecutor;

public class ExtendConstant
implements ISearchOperation {
    private final Object value;
    private final int position;

    public ExtendConstant(int position, Object value) {
        this.position = position;
        this.value = value;
    }

    @Override
    public ISearchOperation.ISearchOperationExecutor createExecutor() {
        return new Executor(this.position);
    }

    @Override
    public List<Integer> getVariablePositions() {
        return Arrays.asList(this.position);
    }

    public String toString() {
        return this.toString(Object::toString);
    }

    @Override
    public String toString(Function<Integer, String> variableMapping) {
        return "extend    constant -" + variableMapping.apply(this.position) + "='" + String.valueOf(this.value) + "'";
    }

    private class Executor
    extends SingleValueExtendOperationExecutor<Object> {
        public Executor(int position) {
            super(position);
        }

        @Override
        public Iterator<?> getIterator(MatchingFrame frame, ISearchContext context) {
            return Collections.singletonList(ExtendConstant.this.value).iterator();
        }

        @Override
        public ISearchOperation getOperation() {
            return ExtendConstant.this;
        }
    }
}

