/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.base.itc.alg.counting;

import java.util.List;
import java.util.Set;
import org.eclipse.viatra.query.runtime.base.itc.alg.counting.CountingTcRelation;
import org.eclipse.viatra.query.runtime.base.itc.alg.misc.DFSPathFinder;
import org.eclipse.viatra.query.runtime.base.itc.alg.misc.IGraphPathFinder;
import org.eclipse.viatra.query.runtime.base.itc.alg.misc.ITcRelation;
import org.eclipse.viatra.query.runtime.base.itc.igraph.IBiDirectionalGraphDataSource;
import org.eclipse.viatra.query.runtime.base.itc.igraph.IBiDirectionalWrapper;
import org.eclipse.viatra.query.runtime.base.itc.igraph.IGraphDataSource;
import org.eclipse.viatra.query.runtime.base.itc.igraph.IGraphObserver;
import org.eclipse.viatra.query.runtime.base.itc.igraph.ITcDataSource;
import org.eclipse.viatra.query.runtime.base.itc.igraph.ITcObserver;
import org.eclipse.viatra.query.runtime.matchers.util.CollectionsFactory;
import org.eclipse.viatra.query.runtime.matchers.util.IMemoryView;

public class CountingAlg<V>
implements IGraphObserver<V>,
ITcDataSource<V> {
    private CountingTcRelation<V> tc = null;
    private IBiDirectionalGraphDataSource<V> gds = null;
    private List<ITcObserver<V>> observers;

    public CountingAlg(IGraphDataSource<V> gds) {
        this.gds = gds instanceof IBiDirectionalGraphDataSource ? (IBiDirectionalGraphDataSource)gds : new IBiDirectionalWrapper<V>(gds);
        this.observers = CollectionsFactory.createObserverList();
        this.tc = new CountingTcRelation(true);
        this.initTc();
        gds.attachObserver(this);
    }

    private void initTc() {
        this.setTcRelation(CountingTcRelation.createFrom(this.gds));
    }

    @Override
    public void edgeInserted(V source, V target) {
        if (!source.equals(target)) {
            this.deriveTc(source, target, true);
        }
    }

    @Override
    public void edgeDeleted(V source, V target) {
        if (!source.equals(target)) {
            this.deriveTc(source, target, false);
        }
    }

    @Override
    public void nodeInserted(V n) {
    }

    @Override
    public void nodeDeleted(V n) {
        this.tc.deleteTupleEnd(n);
    }

    private void deriveTc(V source, V target, boolean isInsertion) {
        CountingTcRelation<Object> dtc = new CountingTcRelation<Object>(false);
        Set<V> tupEnds = null;
        if (this.tc.updateTuple(source, target, isInsertion)) {
            dtc.updateTuple(source, target, true);
            this.notifyTcObservers(source, target, isInsertion);
        }
        if ((tupEnds = this.tc.getTupleEnds(target)) != null) {
            for (V tupEnd : tupEnds) {
                if (tupEnd.equals(source) || !this.tc.updateTuple(source, tupEnd, isInsertion)) continue;
                dtc.updateTuple(source, tupEnd, true);
                this.notifyTcObservers(source, tupEnd, isInsertion);
            }
        }
        CountingTcRelation<Object> newTuples = dtc;
        CountingTcRelation<Object> tmp = null;
        dtc = new CountingTcRelation(false);
        IMemoryView<V> nodes = null;
        while (!newTuples.isEmpty()) {
            tmp = dtc;
            dtc = newTuples;
            newTuples = tmp;
            newTuples.clear();
            for (Object tS : dtc.getTupleStarts()) {
                nodes = this.gds.getSourceNodes(tS);
                for (Object nS : nodes.distinctValues()) {
                    int count = nodes.getCount(nS);
                    int i = 0;
                    while (i < count) {
                        tupEnds = dtc.getTupleEnds(tS);
                        if (tupEnds != null) {
                            for (V tT : tupEnds) {
                                if (nS.equals(tT) || !this.tc.updateTuple(nS, tT, isInsertion)) continue;
                                newTuples.updateTuple(nS, tT, true);
                                this.notifyTcObservers(nS, tT, isInsertion);
                            }
                        }
                        ++i;
                    }
                }
            }
        }
    }

    public ITcRelation<V> getTcRelation() {
        return this.tc;
    }

    public void setTcRelation(CountingTcRelation<V> tc) {
        this.tc = tc;
    }

    @Override
    public boolean isReachable(V source, V target) {
        return this.tc.containsTuple(source, target);
    }

    @Override
    public void attachObserver(ITcObserver<V> to) {
        this.observers.add(to);
    }

    @Override
    public void detachObserver(ITcObserver<V> to) {
        this.observers.remove(to);
    }

    @Override
    public Set<V> getAllReachableTargets(V source) {
        return this.tc.getTupleEnds(source);
    }

    @Override
    public Set<V> getAllReachableSources(V target) {
        return this.tc.getTupleStarts(target);
    }

    private void notifyTcObservers(V source, V target, boolean isInsertion) {
        if (isInsertion) {
            for (ITcObserver<V> o : this.observers) {
                o.tupleInserted(source, target);
            }
        } else {
            for (ITcObserver<V> o : this.observers) {
                o.tupleDeleted(source, target);
            }
        }
    }

    @Override
    public void dispose() {
        this.tc.clear();
        this.gds.detachObserver(this);
    }

    @Override
    public IGraphPathFinder<V> getPathFinder() {
        return new DFSPathFinder<V>(this.gds, this);
    }
}

