/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.bundlor.support.contributors;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.eclipse.virgo.bundlor.ClassPath;
import org.eclipse.virgo.bundlor.ClassPathEntry;
import org.eclipse.virgo.bundlor.support.ArtifactAnalyzer;
import org.eclipse.virgo.bundlor.support.ManifestContributor;
import org.eclipse.virgo.bundlor.support.partialmanifest.PartialManifest;
import org.eclipse.virgo.util.parser.manifest.ManifestContents;

public class BundleClassPathArtifactAnalyzer
implements ArtifactAnalyzer,
ManifestContributor {
    private final List<String> bundleClassPaths = new ArrayList<String>();
    private final List<ArtifactAnalyzer> artifactAnalyzers;
    private final Object monitor = new Object();

    public BundleClassPathArtifactAnalyzer(List<ArtifactAnalyzer> artifactAnalyzers) {
        this.artifactAnalyzers = artifactAnalyzers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void analyse(InputStream artifact, String artefactName, PartialManifest partialManifest) throws Exception {
        Object object = this.monitor;
        synchronized (object) {
            this.bundleClassPaths.add(artefactName.replace('\\', '/'));
            JarInputStream in = null;
            try {
                in = new JarInputStream(artifact);
                this.analyzeEntries(new JarInputStreamClassPath(in), partialManifest);
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
    }

    @Override
    public boolean canAnalyse(String artefactName) {
        return artefactName.endsWith(".jar");
    }

    @Override
    public void contribute(ManifestContents manifest) {
        if (this.bundleClassPaths.size() > 0) {
            StringBuilder sb = new StringBuilder(".");
            for (String bundleClassPath : this.bundleClassPaths) {
                sb.append(String.format(",%s", bundleClassPath));
            }
            manifest.getMainAttributes().put("Bundle-ClassPath", sb.toString());
        }
    }

    private void analyzeEntries(ClassPath classPath, PartialManifest partialManifest) {
        for (ClassPathEntry classPathEntry : classPath) {
            if (classPathEntry.isDirectory()) continue;
            this.analyzeEntry(classPathEntry, partialManifest);
        }
    }

    private void analyzeEntry(ClassPathEntry classPathEntry, PartialManifest partialManifest) {
        for (ArtifactAnalyzer artifactAnalyzer : this.artifactAnalyzers) {
            if (!artifactAnalyzer.canAnalyse(classPathEntry.getName())) continue;
            InputStream inputStream = classPathEntry.getInputStream();
            try {
                try {
                    artifactAnalyzer.analyse(inputStream, classPathEntry.getName(), partialManifest);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (inputStream == null) continue;
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                    continue;
                }
            }
            catch (Throwable throwable) {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (inputStream == null) continue;
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static class JarInputStreamClassPath
    implements ClassPath {
        private final JarInputStream jarInputStream;

        public JarInputStreamClassPath(JarInputStream jarInputStream) {
            this.jarInputStream = jarInputStream;
        }

        @Override
        public Iterator<ClassPathEntry> iterator() {
            return new JarInputStreamClassPathIterator(this.jarInputStream);
        }

        @Override
        public ClassPathEntry getEntry(String name) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() {
            try {
                this.jarInputStream.close();
            }
            catch (IOException iOException) {}
        }

        private static class JarInputStreamClassPathIterator
        implements Iterator<ClassPathEntry> {
            private final JarInputStream jarInputStream;
            private volatile ClassPathEntry nextEntry;
            private final Object monitor = new Object();

            public JarInputStreamClassPathIterator(JarInputStream jarInputStream) {
                this.jarInputStream = jarInputStream;
            }

            @Override
            public boolean hasNext() {
                Object object = this.monitor;
                synchronized (object) {
                    try {
                        JarEntry entry;
                        if (this.nextEntry == null && (entry = this.jarInputStream.getNextJarEntry()) != null) {
                            this.nextEntry = new JarInputStreamClassPathEntry(this.jarInputStream, entry);
                        }
                        return this.nextEntry != null;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ClassPathEntry next() {
                Object object = this.monitor;
                synchronized (object) {
                    ClassPathEntry entry = this.nextEntry;
                    this.nextEntry = null;
                    return entry;
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }

    private static class JarInputStreamClassPathEntry
    implements ClassPathEntry {
        private final byte[] contents;
        private final JarEntry entry;

        public JarInputStreamClassPathEntry(JarInputStream jarInputStream, JarEntry entry) {
            this.contents = this.getEntryContents(jarInputStream);
            this.entry = entry;
        }

        @Override
        public InputStream getInputStream() {
            return new ByteArrayInputStream(this.contents);
        }

        @Override
        public String getName() {
            return this.entry.getName();
        }

        @Override
        public Reader getReader() {
            return new InputStreamReader(this.getInputStream());
        }

        @Override
        public boolean isDirectory() {
            return this.entry.isDirectory();
        }

        public String toString() {
            return this.getName();
        }

        private byte[] getEntryContents(JarInputStream jarInputStream) {
            ByteArrayOutputStream contents = new ByteArrayOutputStream();
            try {
                byte[] buffer = new byte[8192];
                int length = 0;
                while ((length = jarInputStream.read(buffer)) != -1) {
                    contents.write(buffer, 0, length);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return contents.toByteArray();
        }
    }
}

