/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.bundlor.commandline;

import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.eclipse.virgo.bundlor.commandline.BundlorExecutor;
import org.eclipse.virgo.bundlor.commandline.internal.CommandLineBundlorExecutor;
import org.eclipse.virgo.bundlor.commandline.internal.Configuration;
import org.eclipse.virgo.bundlor.commandline.internal.OptionsFactory;
import org.eclipse.virgo.bundlor.commandline.internal.support.StandardConfigurationValidator;
import org.eclipse.virgo.bundlor.commandline.internal.support.StandardManifestTemplateFactory;
import org.eclipse.virgo.bundlor.commandline.internal.support.StandardOsgiProfileFactory;
import org.eclipse.virgo.bundlor.commandline.internal.support.StandardPropertiesSourceFactory;
import org.eclipse.virgo.bundlor.support.classpath.ClassPathFactory;
import org.eclipse.virgo.bundlor.support.classpath.StandardClassPathFactory;
import org.eclipse.virgo.bundlor.support.manifestwriter.ManifestWriterFactory;
import org.eclipse.virgo.bundlor.support.manifestwriter.StandardManifestWriterFactory;

public class Bundlor {
    private static final Options OPTIONS = new OptionsFactory().create();

    public static final void main(String[] args) {
        new Bundlor().run(args);
    }

    final void run(String[] args) {
        CommandLine commandLine = null;
        Configuration configuration = null;
        try {
            commandLine = new PosixParser().parse(OPTIONS, args);
            configuration = new Configuration(commandLine);
        }
        catch (ParseException parseException) {
            new HelpFormatter().printHelp("bundlor.[sh | bat] [OPTION]...", OPTIONS);
            this.exit(-1);
        }
        List<String> warnings = this.getBundlorExecutor(configuration).execute();
        if (warnings.size() > 0) {
            System.out.println("Bundlor Warnings:");
            for (String warning : warnings) {
                System.out.println("    " + warning);
            }
            if (commandLine.hasOption("f")) {
                String message = String.format("Bundlor returned warnings.  Please fix manifest template at '%s' and try again.", configuration.getManifestTemplatePath());
                System.err.println(message);
                this.exit(-1);
            }
        }
    }

    protected BundlorExecutor getBundlorExecutor(Configuration configuration) {
        return new CommandLineBundlorExecutor(configuration, new StandardConfigurationValidator(), (ClassPathFactory)new StandardClassPathFactory(), (ManifestWriterFactory)new StandardManifestWriterFactory(), new StandardManifestTemplateFactory(), new StandardPropertiesSourceFactory(), new StandardOsgiProfileFactory());
    }

    protected void exit(int code) {
        System.exit(code);
    }
}

