/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.runtime.internal.ui.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.virgo.ide.runtime.core.IServerWorkingCopy;
import org.eclipse.virgo.ide.runtime.internal.core.actions.ModifyCleanStartupCommand;
import org.eclipse.virgo.ide.runtime.internal.core.actions.ModifyMaxPermSizeCommand;
import org.eclipse.virgo.ide.runtime.internal.core.actions.ModifyTailLogFilesCommand;
import org.eclipse.wst.server.ui.editor.ServerEditorSection;

public class StartupEditorSection
extends ServerEditorSection {
    protected IServerWorkingCopy serverWorkingCopy;
    protected boolean updating;
    protected PropertyChangeListener listener;
    private Button tailLogFiles;
    private Button cleanStartup;
    private Text maxPermSizeField;

    protected void addConfigurationChangeListener() {
        this.listener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (StartupEditorSection.this.updating) {
                    return;
                }
                StartupEditorSection.this.updating = true;
                if ("org.eclipse.virgo.ide.runtime.coretail.log.files".equals(event.getPropertyName())) {
                    StartupEditorSection.this.tailLogFiles.setSelection(Boolean.valueOf(event.getNewValue().toString()).booleanValue());
                } else if ("org.eclipse.virgo.ide.runtime.coreclean.startup".equals(event.getPropertyName())) {
                    StartupEditorSection.this.cleanStartup.setSelection(Boolean.valueOf(event.getNewValue().toString()).booleanValue());
                } else if ("org.eclipse.virgo.ide.runtime.coremax.perm.size".equals(event.getPropertyName())) {
                    StartupEditorSection.this.maxPermSizeField.setText(event.getNewValue().toString());
                }
                StartupEditorSection.this.updating = false;
            }
        };
        this.serverWorkingCopy.addConfigurationChangeListener(this.listener);
    }

    public void createSection(Composite parent) {
        super.createSection(parent);
        FormToolkit toolkit = this.getFormToolkit(parent.getDisplay());
        Section section = toolkit.createSection(parent, 458);
        section.setText("Server Startup Configuration");
        section.setDescription("Specify startup options. Changing a setting requires a server restart.");
        section.setLayoutData((Object)new GridData(784));
        Composite composite = toolkit.createComposite((Composite)section);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 5;
        layout.marginWidth = 10;
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 15;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(784));
        toolkit.paintBordersFor(composite);
        section.setClient((Control)composite);
        GridData data = new GridData(4, 128, true, false);
        data.horizontalSpan = 2;
        this.tailLogFiles = toolkit.createButton(composite, "Tail application trace files into Console view", 32);
        this.tailLogFiles.setLayoutData((Object)data);
        this.tailLogFiles.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (StartupEditorSection.this.updating) {
                    return;
                }
                StartupEditorSection.this.updating = true;
                StartupEditorSection.this.execute((IUndoableOperation)new ModifyTailLogFilesCommand(StartupEditorSection.this.serverWorkingCopy, StartupEditorSection.this.tailLogFiles.getSelection()));
                StartupEditorSection.this.updating = false;
            }
        });
        this.cleanStartup = toolkit.createButton(composite, "Start server with -clean option", 32);
        this.cleanStartup.setLayoutData((Object)data);
        this.cleanStartup.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (StartupEditorSection.this.updating) {
                    return;
                }
                StartupEditorSection.this.updating = true;
                StartupEditorSection.this.execute((IUndoableOperation)new ModifyCleanStartupCommand(StartupEditorSection.this.serverWorkingCopy, StartupEditorSection.this.cleanStartup.getSelection()));
                StartupEditorSection.this.updating = false;
            }
        });
        data = new GridData(4, 0x1000000, true, false);
        Label maxPermSizeLabel = toolkit.createLabel(composite, "-XX:MaxPermSize=");
        maxPermSizeLabel.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.maxPermSizeField = toolkit.createText(composite, "");
        this.maxPermSizeField.setLayoutData((Object)data);
        this.maxPermSizeField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (StartupEditorSection.this.updating) {
                    return;
                }
                StartupEditorSection.this.updating = true;
                StartupEditorSection.this.execute((IUndoableOperation)new ModifyMaxPermSizeCommand(StartupEditorSection.this.serverWorkingCopy, StartupEditorSection.this.maxPermSizeField.getText()));
                StartupEditorSection.this.updating = false;
            }
        });
        toolkit.createLabel(composite, "");
        this.initialize();
    }

    public void dispose() {
        if (this.server != null) {
            this.server.removePropertyChangeListener(this.listener);
        }
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        this.serverWorkingCopy = (IServerWorkingCopy)this.server.loadAdapter(IServerWorkingCopy.class, (IProgressMonitor)new NullProgressMonitor());
        this.addConfigurationChangeListener();
    }

    protected void initialize() {
        this.updating = true;
        this.tailLogFiles.setSelection(this.serverWorkingCopy.shouldTailTraceFiles());
        this.cleanStartup.setSelection(this.serverWorkingCopy.shouldCleanStartup());
        this.maxPermSizeField.setText(this.serverWorkingCopy.getMaxPermSize());
        this.updating = false;
    }
}

