/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.pde.core.internal;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.virgo.ide.pde.core.internal.Messages;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Helper {
    static boolean DEBUG = "true".equals(Platform.getDebugOption((String)"org.eclipse.virgo.ide.pde.core/debug"));
    private static ILog log = Platform.getLog((Bundle)FrameworkUtil.getBundle(Helper.class));
    private static final QualifiedName EDITOR_PROPERTY = new QualifiedName("org.eclipse.ui.internal.registry.ResourceEditorRegistry", "EditorProperty");
    private static final String EDITOR_VALUE = "org.eclipse.pde.ui.manifestEditor";

    static void debug(String message) {
        log.log((IStatus)new Status(0, "org.eclipse.virgo.ide.pde.core", message));
    }

    static void error(String message) {
        log.log((IStatus)new Status(4, "org.eclipse.virgo.ide.pde.core", message));
    }

    static boolean checkMETAINFFolder(IProject project) throws CoreException {
        IPath outputLocation = Helper.getOutputLocation(project);
        IFolder binFolder = ResourcesPlugin.getWorkspace().getRoot().getFolder(outputLocation);
        if (!binFolder.exists()) {
            if (DEBUG) {
                Helper.debug("Creating bin folder");
            }
            binFolder.create(true, true, null);
            return false;
        }
        if (DEBUG) {
            Helper.debug("Refreshing bin folder");
        }
        binFolder.refreshLocal(1, null);
        IFolder binaryMetaInf = binFolder.getFolder("META-INF");
        if (!binaryMetaInf.exists()) {
            if (DEBUG) {
                Helper.debug("Creating bin/META-INF");
            }
            binaryMetaInf.create(true, true, null);
            return false;
        }
        if (DEBUG) {
            Helper.debug("bin/META-INF already exists, refreshing");
        }
        binaryMetaInf.refreshLocal(2, null);
        IFile binaryManifest = binaryMetaInf.getFile("MANIFEST.MF");
        if (!binaryManifest.exists()) {
            if (DEBUG) {
                Helper.debug("bin/META-INF/MANIFEST.MF does not exist");
            }
            return false;
        }
        return true;
    }

    static List<String> getLibraryEntries(IProject project) throws CoreException {
        List<String> toCopy = Helper.getEntries(project);
        if (DEBUG) {
            Helper.debug("JARS declared in manifest: " + Arrays.toString(toCopy.toArray()));
        }
        return toCopy;
    }

    private static List<String> getEntries(IProject project) throws CoreException {
        int n;
        int n2;
        String[] stringArray;
        IFolder metaInf = project.getFolder("META-INF");
        if (!metaInf.exists()) {
            return Collections.emptyList();
        }
        IFile manifest = metaInf.getFile("MANIFEST.MF");
        if (!manifest.exists()) {
            return Collections.emptyList();
        }
        HashMap manifestEntries = new HashMap();
        try {
            ManifestElement.parseBundleManifest((InputStream)manifest.getContents(), manifestEntries);
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.virgo.ide.pde.core", Messages.Helper_ManifestParsingError, (Throwable)e));
        }
        ArrayList<String> toCopy = new ArrayList<String>();
        String rawValue = (String)manifestEntries.get("Bundle-ClassPath");
        if (rawValue != null) {
            String[] classpathEntries;
            stringArray = classpathEntries = ManifestElement.getArrayFromList((String)rawValue);
            n2 = classpathEntries.length;
            n = 0;
            while (n < n2) {
                String classpathEntry = stringArray[n];
                if (!".".equals(classpathEntry) && classpathEntry.toLowerCase().endsWith(".jar")) {
                    toCopy.add(classpathEntry);
                }
                ++n;
            }
        }
        if ((rawValue = (String)manifestEntries.get("Bundle-NativeCode")) != null) {
            ManifestElement[] value;
            try {
                value = ManifestElement.parseHeader((String)"Bundle-NativeCode", (String)rawValue);
            }
            catch (BundleException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.virgo.ide.pde.core", Messages.Helper_ManifestParsingError, (Throwable)e));
            }
            stringArray = value;
            n2 = value.length;
            n = 0;
            while (n < n2) {
                String manifestElement = stringArray[n];
                toCopy.add(manifestElement.getValue());
                ++n;
            }
        }
        return toCopy;
    }

    static IPath getOutputLocation(IProject project) throws CoreException {
        IJavaProject jp = (IJavaProject)project.getNature("org.eclipse.jdt.core.javanature");
        IPath outputLocation = jp.getOutputLocation();
        if (outputLocation == null) {
            IClasspathEntry[] entries;
            IClasspathEntry[] iClasspathEntryArray = entries = jp.getRawClasspath();
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry iClasspathEntry = iClasspathEntryArray[n2];
                if (iClasspathEntry.getEntryKind() == 3 && (outputLocation = iClasspathEntry.getOutputLocation()) != null) break;
                ++n2;
            }
        }
        if (outputLocation == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.virgo.ide.pde.core", Messages.Helper_BinFolderError));
        }
        return outputLocation;
    }

    static void copyLibraryToBin(IProject project, String path) throws CoreException {
        IResource libraryResource;
        IPath outputLocation = Helper.getOutputLocation(project);
        IFolder binFolder = ResourcesPlugin.getWorkspace().getRoot().getFolder(outputLocation);
        IResource target = binFolder.findMember(path);
        if (target != null && target.exists()) {
            if (DEBUG) {
                Helper.debug(String.valueOf(path) + " already exists, deleting");
            }
            target.delete(true, null);
            if (DEBUG) {
                Helper.debug(String.valueOf(path) + " deleted");
            }
        }
        if ((libraryResource = project.findMember((IPath)new Path(path))) != null) {
            IPath destinationPath = binFolder.getFullPath().append(path);
            IPath binRelativePath = destinationPath.removeFirstSegments(outputLocation.segmentCount());
            int segmentCount = (binRelativePath = binRelativePath.removeLastSegments(1)).segmentCount();
            if (segmentCount > 0) {
                int i = 0;
                while (i < segmentCount) {
                    IFolder aFolder = binFolder.getFolder(binRelativePath.removeLastSegments(segmentCount - 1 - i));
                    if (!aFolder.exists()) {
                        if (DEBUG) {
                            Helper.debug("parent folder does not exist: " + aFolder.getFullPath().toString());
                        }
                        aFolder.create(true, true, null);
                        if (DEBUG) {
                            Helper.debug("parent folder created");
                        }
                    }
                    ++i;
                }
            }
            switch (libraryResource.getType()) {
                case 1: {
                    IFile libraryFile = project.getFile((IPath)new Path(path));
                    libraryFile.copy(destinationPath, true, null);
                    break;
                }
                case 2: {
                    IFolder libraryFolder = project.getFolder((IPath)new Path(path));
                    libraryFolder.copy(destinationPath, true, null);
                }
            }
            if (DEBUG) {
                Helper.debug("copied " + libraryResource.getFullPath().toString() + " to " + destinationPath.toString());
            }
        } else if (DEBUG) {
            Helper.debug("Manifest contains unexisting library entry: " + path);
        }
    }

    static boolean checkLibraries(IProject project) throws CoreException {
        List<String> entries = Helper.getLibraryEntries(project);
        if (entries.isEmpty()) {
            return true;
        }
        return Helper.checkFilesExist(project, entries);
    }

    private static boolean checkFilesExist(IProject project, List<String> entries) throws CoreException {
        IPath outputLocation = Helper.getOutputLocation(project);
        for (String string : entries) {
            if (!project.getFile(string).exists()) continue;
            IPath binFile = outputLocation.append(string);
            IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(binFile);
            if (res != null) continue;
            return false;
        }
        return true;
    }

    public static void forcePDEEditor(IProject project) {
        block3: {
            IFile manifest;
            IFolder metaInf = project.getFolder("META-INF");
            if (metaInf.exists() && (manifest = metaInf.getFile("MANIFEST.MF")).exists()) {
                try {
                    manifest.setPersistentProperty(EDITOR_PROPERTY, EDITOR_VALUE);
                }
                catch (CoreException e) {
                    if (!DEBUG) break block3;
                    log.log(e.getStatus());
                }
            }
        }
    }
}

