/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.jdt.internal.core.classpath;

import java.util.Arrays;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.virgo.ide.facet.core.FacetUtils;
import org.eclipse.virgo.ide.jdt.internal.core.classpath.ServerClasspathContainerUpdateJob;
import org.eclipse.virgo.ide.manifest.core.IBundleManifestChangeListener;
import org.eclipse.virgo.ide.manifest.internal.core.BundleManifestManager;
import org.eclipse.virgo.ide.runtime.core.ServerUtils;
import org.eclipse.virgo.ide.runtime.core.provisioning.IBundleRepositoryChangeListener;
import org.eclipse.virgo.util.osgi.manifest.BundleManifest;
import org.eclipse.wst.server.core.IRuntime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerClasspathContainerBundleManifestChangeListener
implements IBundleManifestChangeListener,
IBundleRepositoryChangeListener {
    public void bundleManifestChanged(BundleManifest newBundleManifest, BundleManifest oldBundleManifest, BundleManifest newTestBundleManifest, BundleManifest oldTestBundleManifest, Set<IBundleManifestChangeListener.Type> types, IJavaProject javaProject) {
        if (newBundleManifest != null || newTestBundleManifest != null) {
            ServerClasspathContainerUpdateJob.scheduleClasspathContainerUpdateJob(javaProject, types);
        }
    }

    public void bundleRepositoryChanged(IRuntime runtime) {
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (FacetUtils.isBundleProject((IResource)project) && Arrays.asList(ServerUtils.getTargettedRuntimes((IProject)project)).contains(runtime)) {
                ServerClasspathContainerUpdateJob.scheduleClasspathContainerUpdateJob(JavaCore.create((IProject)project), BundleManifestManager.IMPORTS_CHANGED);
            }
            ++n2;
        }
    }
}

