/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.runtime.internal.ui.providers;

import java.util.ArrayList;
import org.apache.commons.lang.ArrayUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.virgo.ide.runtime.internal.ui.projects.ServerProject;
import org.eclipse.virgo.ide.runtime.internal.ui.projects.ServerProjectManager;
import org.eclipse.virgo.ide.runtime.internal.ui.providers.GenericTreeProvider;
import org.eclipse.virgo.ide.runtime.internal.ui.providers.ServerFile;
import org.eclipse.wst.server.core.IServer;

public abstract class ServerFileContentProvider
extends GenericTreeProvider {
    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof IServer) {
            IServer server = (IServer)inputElement;
            ServerProject project = ServerProjectManager.getInstance().getProject(server);
            if (project != null) {
                ArrayList<ServerFile> files = new ArrayList<ServerFile>();
                String[] stringArray = this.getServerDirectories(server);
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String serverDir = stringArray[n2];
                    IFolder folder = project.getWorkspaceProject().getFolder(String.valueOf(this.getBaseDirectory()) + "/" + serverDir);
                    try {
                        IResource[] members;
                        IResource[] iResourceArray = members = folder.members();
                        int n3 = members.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IResource resource = iResourceArray[n4];
                            if (this.isIncludeType(resource)) {
                                files.add(new ServerFile(server, (IFile)resource));
                            }
                            ++n4;
                        }
                    }
                    catch (CoreException e) {
                        StatusManager.getManager().handle(e.getStatus());
                    }
                    ++n2;
                }
                return files.toArray(new Object[files.size()]);
            }
        }
        return super.getElements(inputElement);
    }

    public boolean isIncludeType(IResource resource) {
        if (resource instanceof IFile) {
            String ext = resource.getFileExtension();
            if (ext == null) {
                return this.isIncludeNoExtension();
            }
            if (this.getIncludeExtensions() != null) {
                return ArrayUtils.contains((Object[])this.getIncludeExtensions(), (Object)ext);
            }
            if (this.getExcludeExtensions() != null) {
                return !ArrayUtils.contains((Object[])this.getExcludeExtensions(), (Object)ext);
            }
            return true;
        }
        return false;
    }

    public abstract String getBaseDirectory();

    public abstract String[] getIncludeExtensions();

    public abstract String[] getExcludeExtensions();

    public abstract String[] getServerDirectories(IServer var1);

    public abstract boolean isIncludeNoExtension();

    public Object getParent(Object element) {
        if (element instanceof ServerFile) {
            return ((ServerFile)element).getServer();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof IServer && ServerProject.isVirgo((IServer)((IServer)element));
    }
}

