/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.repository.internal.external;

import java.io.File;
import java.io.IOException;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.repository.internal.external.AntPathMatcher;
import org.eclipse.virgo.repository.internal.external.FileSystemSearcher;
import org.eclipse.virgo.util.io.FileSystemUtils;

public final class AntPathMatchingFileSystemSearcher
implements FileSystemSearcher {
    private static final String REGEX_MATCHING_BACKSLASH = "\\\\";
    private static final String BACKSLASH_SEPARATOR = "\\";
    private final File rootDir;
    private final String antPathPattern;
    private final AntPathMatcher antPathMatcher;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;

    File getRootDir() {
        return this.rootDir;
    }

    boolean matchPath(String filePath) {
        return this.antPathMatcher.match(this.antPathPattern, filePath);
    }

    public AntPathMatchingFileSystemSearcher(String antPathPattern) {
        if (!AntPathMatchingFileSystemSearcher.isAbsolute(antPathPattern)) {
            throw new IllegalArgumentException(String.format("The search pattern '%s' is not absolute.", antPathPattern));
        }
        String[] pathComponents = antPathPattern.split(File.separator.equals(BACKSLASH_SEPARATOR) ? REGEX_MATCHING_BACKSLASH : File.separator);
        StringBuilder rootPathBuilder = new StringBuilder();
        StringBuilder antPatternBuilder = new StringBuilder();
        boolean rootPathBuilt = false;
        String[] stringArray = pathComponents;
        int n = pathComponents.length;
        int n2 = 0;
        while (n2 < n) {
            String component = stringArray[n2];
            if (!(rootPathBuilt || component.contains("*") || component.contains("?"))) {
                rootPathBuilder.append(File.separator);
                rootPathBuilder.append(component);
            } else {
                rootPathBuilt = true;
                antPatternBuilder.append(File.separator);
                antPatternBuilder.append(component);
            }
            ++n2;
        }
        try {
            this.rootDir = new File(rootPathBuilder.toString()).getCanonicalFile();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unable to determine canonical root directory from '" + rootPathBuilder.toString() + "'", ioe);
        }
        this.antPathMatcher = new AntPathMatcher();
        this.antPathMatcher.setPathSeparator(File.separator);
        this.antPathPattern = String.valueOf(this.rootDir.getPath()) + antPatternBuilder.toString();
    }

    private static boolean isAbsolute(String searchPattern) {
        return searchPattern.startsWith("/") || searchPattern.indexOf(":") > 0;
    }

    public void search(FileSystemSearcher.SearchCallback callback) {
        this.search(this.rootDir, callback);
    }

    private void search(File file, FileSystemSearcher.SearchCallback callback) {
        String absolutePath = file.getAbsolutePath();
        if (this.antPathMatcher.match(this.antPathPattern, absolutePath)) {
            callback.found(file, true);
        } else if (file.isDirectory() && this.antPathMatcher.matchStart(this.antPathPattern, absolutePath)) {
            callback.found(file, false);
        }
        if (file.isDirectory()) {
            File[] fileArray = FileSystemUtils.listFiles((File)file);
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File fileInDir = fileArray[n2];
                this.search(fileInDir, callback);
                ++n2;
            }
        }
    }

    public String toString() {
        return this.antPathPattern;
    }

    public static /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$localAspectOf() {
        return ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    }

    static {
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.repository.internal.external.AntPathMatchingFileSystemSearcher");
    }
}

