/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.deployer.hot;

import java.io.File;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.kernel.deployer.core.ApplicationDeployer;
import org.eclipse.virgo.kernel.deployer.core.DeployerConfiguration;
import org.eclipse.virgo.kernel.deployer.hot.HotDeploymentFileSystemListener;
import org.eclipse.virgo.kernel.deployer.hot.WatchTask;
import org.eclipse.virgo.kernel.serviceability.NonNull;
import org.eclipse.virgo.kernel.serviceability.dump.DumpCoordinator;
import org.eclipse.virgo.kernel.serviceability.enforcement.NonNullAssertionEnforcer;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.util.io.FileSystemChecker;
import org.eclipse.virgo.util.io.FileSystemListener;
import org.eclipse.virgo.util.io.PathReference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HotDeployer
implements EventHandler {
    private static final String EXCLUDE_PATTERN = "\\.DS_Store";
    private static final String TOPIC_RECOVERY_COMPLETED = "org/eclipse/virgo/kernel/deployer/recovery/COMPLETED";
    private Logger logger;
    private final Object lifecycleLock;
    private final File pickupDir;
    private final Thread thread;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;

    public HotDeployer(@NonNull DeployerConfiguration deployerConfiguration, @NonNull ApplicationDeployer deployer, EventLogger eventLogger) {
        ApplicationDeployer applicationDeployer = deployer;
        DeployerConfiguration deployerConfiguration2 = deployerConfiguration;
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_kernel_serviceability_enforcement_NonNullAssertionEnforcer$1$7118cd8((Object)deployerConfiguration2);
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_kernel_serviceability_enforcement_NonNullAssertionEnforcer$2$ea5bfc82((Object)applicationDeployer);
        try {
            try {
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            this.logger = LoggerFactory.getLogger(this.getClass());
            this.lifecycleLock = new Object();
            this.pickupDir = this.createHotDeployDir(deployerConfiguration.getDeploymentPickupDirectory());
            FileSystemChecker checker = this.createFileSystemChecker(deployer, eventLogger);
            this.thread = new Thread((Runnable)new WatchTask(checker, this.pickupDir), "fs-watcher");
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private FileSystemChecker createFileSystemChecker(ApplicationDeployer deployer, EventLogger eventLogger) {
        try {
            try {
                HotDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_0);
                FileSystemChecker checker = new FileSystemChecker(this.pickupDir, EXCLUDE_PATTERN, this.logger);
                checker.addListener((FileSystemListener)new HotDeploymentFileSystemListener(deployer, eventLogger));
                FileSystemChecker fileSystemChecker = checker;
                HotDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_0);
                return fileSystemChecker;
            }
            catch (Throwable throwable) {
                HotDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_0);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - void declaration
     */
    File createHotDeployDir(@NonNull PathReference pathReference) {
        PathReference pathReference2 = pathReference;
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_kernel_serviceability_enforcement_NonNullAssertionEnforcer$1$7118cd8((Object)pathReference2);
        try {
            try {
                void pickUpDirectoryPath;
                HotDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_1);
                if (pickUpDirectoryPath.isFile()) {
                    this.logger.debug("Deleting stray file from hot deployment directory location '{}'.", (Object)pickUpDirectoryPath.getAbsolutePath());
                    pickUpDirectoryPath.delete();
                }
                if (!pickUpDirectoryPath.exists()) {
                    this.logger.info("Creating hot deployment directory at '{}'.", (Object)pickUpDirectoryPath.getAbsolutePath());
                    pickUpDirectoryPath.createDirectory();
                } else {
                    this.logger.info("Using hot deployment directory at '{}'.", (Object)pickUpDirectoryPath.getAbsolutePath());
                }
                File file = pickUpDirectoryPath.toFile();
                HotDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_1);
                return file;
            }
            catch (Throwable throwable) {
                HotDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_1);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doStart() {
        try {
            try {
                HotDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_2);
                Object object = this.lifecycleLock;
                synchronized (object) {
                    if (this.thread != null) {
                        this.thread.start();
                        this.logger.info("Started hot deployer on '{}'.", (Object)this.pickupDir);
                    }
                }
                HotDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_2);
                return;
            }
            catch (Throwable throwable) {
                HotDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_2);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        try {
            try {
                HotDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_3);
                Object object = this.lifecycleLock;
                synchronized (object) {
                    if (this.thread != null) {
                        this.logger.info("Stopping hot deployer");
                        this.thread.interrupt();
                    }
                }
                HotDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_3);
                return;
            }
            catch (Throwable throwable) {
                HotDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_3);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public String toString() {
        try {
            try {
                HotDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_4);
                String string = String.format("Hot Deployer [pickupDir = %s]", this.pickupDir.getAbsolutePath());
                HotDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_4);
                return string;
            }
            catch (Throwable throwable) {
                HotDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_4);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public void handleEvent(Event event) {
        try {
            try {
                HotDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_5);
                if (TOPIC_RECOVERY_COMPLETED.equals(event.getTopic())) {
                    this.doStart();
                }
                HotDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_5);
                return;
            }
            catch (Throwable throwable) {
                HotDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_5);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    static {
        Factory factory = new Factory("HotDeployer.java", Class.forName("org.eclipse.virgo.kernel.deployer.hot.HotDeployer"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "createFileSystemChecker", "org.eclipse.virgo.kernel.deployer.hot.HotDeployer", "org.eclipse.virgo.kernel.deployer.core.ApplicationDeployer:org.eclipse.virgo.medic.eventlog.EventLogger:", "deployer:eventLogger:", "", "org.eclipse.virgo.util.io.FileSystemChecker"), 68);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "createHotDeployDir", "org.eclipse.virgo.kernel.deployer.hot.HotDeployer", "org.eclipse.virgo.util.io.PathReference:", "pickUpDirectoryPath:", "", "java.io.File"), 80);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "doStart", "org.eclipse.virgo.kernel.deployer.hot.HotDeployer", "", "", "", "void"), 97);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "stop", "org.eclipse.virgo.kernel.deployer.hot.HotDeployer", "", "", "", "void"), 109);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "toString", "org.eclipse.virgo.kernel.deployer.hot.HotDeployer", "", "", "", "java.lang.String"), 122);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "handleEvent", "org.eclipse.virgo.kernel.deployer.hot.HotDeployer", "org.osgi.service.event.Event:", "event:", "", "void"), 129);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.deployer.hot.HotDeployer");
    }
}

