/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.console.ssh;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.felix.service.command.CommandProcessor;
import org.apache.felix.service.command.CommandSession;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.ExitCallback;
import org.eclipse.equinox.console.common.ConsoleInputStream;
import org.eclipse.equinox.console.common.ConsoleOutputStream;
import org.eclipse.equinox.console.common.KEYS;
import org.eclipse.equinox.console.common.terminal.ANSITerminalTypeMappings;
import org.eclipse.equinox.console.common.terminal.SCOTerminalTypeMappings;
import org.eclipse.equinox.console.common.terminal.TerminalTypeMappings;
import org.eclipse.equinox.console.common.terminal.VT100TerminalTypeMappings;
import org.eclipse.equinox.console.common.terminal.VT220TerminalTypeMappings;
import org.eclipse.equinox.console.common.terminal.VT320TerminalTypeMappings;
import org.eclipse.equinox.console.ssh.SshInputHandler;
import org.eclipse.equinox.console.storage.SecureUserStore;
import org.eclipse.equinox.console.supportability.ConsoleInputHandler;
import org.eclipse.equinox.console.supportability.ConsoleInputScanner;
import org.osgi.framework.BundleContext;

public class SshShell
implements Command,
Closeable {
    private CommandProcessor processor;
    private BundleContext context;
    private InputStream in;
    private OutputStream out;
    private ExitCallback callback;
    private Thread thread;
    private final Map<String, TerminalTypeMappings> supportedEscapeSequences;
    private static final String DEFAULT_TTYPE = File.separatorChar == '/' ? "XTERM" : "ANSI";
    private TerminalTypeMappings currentMappings;
    private Map<String, KEYS> currentEscapesToKey;
    private static final String PROMPT = "prompt";
    private static final String OSGI_PROMPT = "osgi> ";
    private static final String INPUT_SCANNER = "INPUT_SCANNER";
    private static final String SSH_INPUT_SCANNER = "SSH_INPUT_SCANNER";
    private static final String USER_STORAGE_PROPERTY_NAME = "osgi.console.ssh.useDefaultSecureStorage";
    private static final String DEFAULT_USER = "equinox";
    private static final String TERMINAL_PROPERTY = "TERM";
    private static final String CLOSEABLE = "CLOSEABLE";
    private static final int ADD_USER_COUNTER_LIMIT = 2;

    public SshShell(CommandProcessor processor, BundleContext context) {
        this.processor = processor;
        this.context = context;
        this.supportedEscapeSequences = new HashMap<String, TerminalTypeMappings>();
        this.supportedEscapeSequences.put("ANSI", new ANSITerminalTypeMappings());
        this.supportedEscapeSequences.put("WINDOWS", new ANSITerminalTypeMappings());
        this.supportedEscapeSequences.put("VT100", new VT100TerminalTypeMappings());
        VT220TerminalTypeMappings vtMappings = new VT220TerminalTypeMappings();
        this.supportedEscapeSequences.put("VT220", vtMappings);
        this.supportedEscapeSequences.put("XTERM", vtMappings);
        this.supportedEscapeSequences.put("VT320", new VT320TerminalTypeMappings());
        this.supportedEscapeSequences.put("SCO", new SCOTerminalTypeMappings());
        this.currentMappings = this.supportedEscapeSequences.get(DEFAULT_TTYPE);
        this.currentEscapesToKey = this.currentMappings.getEscapesToKey();
    }

    public void setInputStream(InputStream in) {
        this.in = in;
    }

    public void setOutputStream(OutputStream out) {
        this.out = out;
    }

    public void setErrorStream(OutputStream err) {
    }

    public void setExitCallback(ExitCallback callback) {
        this.callback = callback;
    }

    public void start(Environment env) throws IOException {
        String term = (String)env.getEnv().get(TERMINAL_PROPERTY);
        TerminalTypeMappings mapping = this.supportedEscapeSequences.get(term.toUpperCase());
        if (mapping != null) {
            this.currentMappings = mapping;
            this.currentEscapesToKey = mapping.getEscapesToKey();
        }
        ConsoleInputStream input = new ConsoleInputStream();
        ConsoleOutputStream outp = new ConsoleOutputStream(this.out);
        SshInputHandler inputHandler = new SshInputHandler(this.in, input, outp);
        inputHandler.getScanner().setBackspace(this.currentMappings.getBackspace());
        inputHandler.getScanner().setDel(this.currentMappings.getDel());
        inputHandler.getScanner().setCurrentEscapesToKey(this.currentEscapesToKey);
        inputHandler.getScanner().setEscapes(this.currentMappings.getEscapes());
        inputHandler.start();
        ConsoleInputStream inp = new ConsoleInputStream();
        ConsoleInputHandler consoleInputHandler = new ConsoleInputHandler(input, inp, outp);
        consoleInputHandler.getScanner().setBackspace(this.currentMappings.getBackspace());
        consoleInputHandler.getScanner().setDel(this.currentMappings.getDel());
        consoleInputHandler.getScanner().setCurrentEscapesToKey(this.currentEscapesToKey);
        consoleInputHandler.getScanner().setEscapes(this.currentMappings.getEscapes());
        ((ConsoleInputScanner)consoleInputHandler.getScanner()).setContext(this.context);
        consoleInputHandler.start();
        PrintStream output = new PrintStream(outp);
        final CommandSession session = this.processor.createSession((InputStream)inp, output, output);
        session.put(PROMPT, (Object)OSGI_PROMPT);
        session.put(INPUT_SCANNER, (Object)consoleInputHandler.getScanner());
        session.put(SSH_INPUT_SCANNER, (Object)inputHandler.getScanner());
        session.put(CLOSEABLE, (Object)this);
        ((ConsoleInputScanner)consoleInputHandler.getScanner()).setSession(session);
        this.thread = new Thread(){

            public void run() {
                try {
                    try {
                        if ("true".equals(SshShell.this.context.getProperty(SshShell.USER_STORAGE_PROPERTY_NAME))) {
                            String[] names;
                            String[] stringArray = names = SecureUserStore.getUserNames();
                            int n = names.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String name = stringArray[n2];
                                if (SshShell.DEFAULT_USER.equals(name)) {
                                    if (names.length == 1) {
                                        session.getConsole().println("Currently the default user is the only one; since it will be deleted after first login, create a new user:");
                                        boolean isUserAdded = false;
                                        int count = 0;
                                        while (!isUserAdded && count < 2) {
                                            isUserAdded = (Boolean)session.execute((CharSequence)"addUser");
                                            ++count;
                                        }
                                        if (!isUserAdded) break;
                                    }
                                    if (!SecureUserStore.existsUser(name)) break;
                                    SecureUserStore.deleteUser(name);
                                    break;
                                }
                                ++n2;
                            }
                        }
                        session.execute((CharSequence)"gosh --login --noshutdown");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        session.close();
                    }
                }
                finally {
                    session.close();
                }
            }
        };
        this.thread.start();
    }

    public void destroy() {
    }

    public void onExit() {
        this.thread.interrupt();
        this.callback.onExit(0);
    }

    public void close() {
        this.onExit();
    }
}

