/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.artifact.plan;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.virgo.kernel.artifact.ArtifactSpecification;
import org.eclipse.virgo.kernel.artifact.plan.PlanBridge;
import org.eclipse.virgo.kernel.artifact.plan.PlanDescriptor;
import org.eclipse.virgo.kernel.artifact.plan.internal.PlanReaderEntityResolver;
import org.eclipse.virgo.kernel.artifact.plan.internal.PlanReaderErrorHandler;
import org.eclipse.virgo.util.common.PropertyPlaceholderResolver;
import org.eclipse.virgo.util.osgi.VersionRange;
import org.osgi.framework.Version;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class PlanReader {
    private static final String NAME_ATTRIBUTE = "name";
    private static final String VERSION_ATTRIBUTE = "version";
    private static final String SCOPED_ATTRIBUTE = "scoped";
    private static final String ATOMIC_ATTRIBUTE = "atomic";
    private static final String ARTIFACT_ELEMENT = "artifact";
    private static final String ATTRIBUTE_ELEMENT = "attribute";
    private static final String PROPERTY_ELEMENT = "property";
    private static final String TYPE_ATTRIBUTE = "type";
    private static final String VALUE_ATTRIBUTE = "value";
    private static final String SCHEMA_LANGUAGE_ATTRIBUTE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String XSD_SCHEMA_LANGUAGE = "http://www.w3.org/2001/XMLSchema";
    private final PropertyPlaceholderResolver resolver = new PropertyPlaceholderResolver();

    public PlanDescriptor read(InputStream inputStream) {
        try {
            Document doc = this.readDocument(inputStream);
            Element element = doc.getDocumentElement();
            return this.parsePlanElement(element);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to read plan descriptor", e);
        }
    }

    private Document readDocument(InputStream inputStream) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder builder = this.createDocumentBuilderFactory().newDocumentBuilder();
        builder.setEntityResolver(new PlanReaderEntityResolver());
        builder.setErrorHandler(new PlanReaderErrorHandler(LoggerFactory.getLogger(PlanBridge.class)));
        return builder.parse(inputStream);
    }

    private DocumentBuilderFactory createDocumentBuilderFactory() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(true);
        factory.setNamespaceAware(true);
        factory.setAttribute(SCHEMA_LANGUAGE_ATTRIBUTE, XSD_SCHEMA_LANGUAGE);
        return factory;
    }

    private PlanDescriptor parsePlanElement(Element element) {
        String name = element.getAttribute(NAME_ATTRIBUTE);
        Version version = new Version(element.getAttribute(VERSION_ATTRIBUTE));
        boolean scoped = Boolean.parseBoolean(element.getAttribute(SCOPED_ATTRIBUTE));
        boolean atomic = Boolean.parseBoolean(element.getAttribute(ATOMIC_ATTRIBUTE));
        Properties attributes = this.parseAttributes(element);
        List<ArtifactSpecification> artifactSpecifications = this.parseArtifactElements(element.getElementsByTagName(ARTIFACT_ELEMENT), attributes);
        return new PlanDescriptor(name, version, scoped, atomic, artifactSpecifications);
    }

    private Properties parseAttributes(Element element) {
        Properties result = new Properties();
        NodeList attributeElements = element.getElementsByTagName(ATTRIBUTE_ELEMENT);
        int x = 0;
        while (x < attributeElements.getLength()) {
            Element attribute = (Element)attributeElements.item(x);
            String name = attribute.getAttribute(NAME_ATTRIBUTE);
            String value = attribute.getAttribute(VALUE_ATTRIBUTE);
            result.put(name, value);
            ++x;
        }
        return result;
    }

    private List<ArtifactSpecification> parseArtifactElements(NodeList artifactElements, Properties attributes) {
        ArrayList<ArtifactSpecification> artifactSpecifications = new ArrayList<ArtifactSpecification>(artifactElements.getLength());
        int i = 0;
        while (i < artifactElements.getLength()) {
            Element artifactElement = (Element)artifactElements.item(i);
            String type = this.replacePlaceholders(artifactElement.getAttribute(TYPE_ATTRIBUTE), attributes);
            String name = this.replacePlaceholders(artifactElement.getAttribute(NAME_ATTRIBUTE), attributes);
            String version = this.replacePlaceholders(artifactElement.getAttribute(VERSION_ATTRIBUTE), attributes);
            Map<String, String> properties = this.parseArtifactProperties(artifactElement, attributes);
            artifactSpecifications.add(new ArtifactSpecification(type, name, new VersionRange(version), properties));
            ++i;
        }
        return artifactSpecifications;
    }

    private Map<String, String> parseArtifactProperties(Element artifactElement, Properties attributes) {
        HashMap<String, String> result = new HashMap<String, String>();
        NodeList propertyElements = artifactElement.getElementsByTagName(PROPERTY_ELEMENT);
        int x = 0;
        while (x < propertyElements.getLength()) {
            Element propertyElement = (Element)propertyElements.item(x);
            String name = this.replacePlaceholders(propertyElement.getAttribute(NAME_ATTRIBUTE), attributes);
            String value = this.replacePlaceholders(propertyElement.getAttribute(VALUE_ATTRIBUTE), attributes);
            result.put(name, value);
            ++x;
        }
        return result;
    }

    private String replacePlaceholders(String value, Properties attributes) {
        return this.resolver.resolve(value, attributes);
    }
}

