/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.nano.deployer.internal;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.virgo.kernel.core.KernelConfig;
import org.eclipse.virgo.kernel.deployer.core.ApplicationDeployer;
import org.eclipse.virgo.kernel.deployer.core.DeploymentException;
import org.eclipse.virgo.kernel.deployer.core.DeploymentIdentity;
import org.eclipse.virgo.kernel.deployer.core.DeploymentOptions;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.medic.eventlog.LogEvent;
import org.eclipse.virgo.nano.deployer.NanoDeployerLogEvents;
import org.eclipse.virgo.nano.deployer.SimpleDeployer;
import org.eclipse.virgo.nano.deployer.hot.HotDeployerEnabler;
import org.eclipse.virgo.nano.deployer.internal.BundleDeployer;
import org.eclipse.virgo.nano.deployer.internal.StandardDeployerConfiguration;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.packageadmin.PackageAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardApplicationDeployer
implements ApplicationDeployer {
    private EventLogger eventLogger;
    private PackageAdmin packageAdmin;
    private final List<SimpleDeployer> simpleDeployers = new ArrayList<SimpleDeployer>();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private KernelConfig kernelConfig;
    private HotDeployerEnabler hotDeployerEnabler = null;
    private BundleContext bundleContext;
    private BundleDeployer defaultDeployer;

    public void activate(ComponentContext context) throws Exception {
        this.bundleContext = context.getBundleContext();
        this.defaultDeployer = new BundleDeployer(context.getBundleContext(), this.packageAdmin, this.eventLogger);
        this.simpleDeployers.add(this.defaultDeployer);
        this.initialiseHotDeployer();
    }

    public void deactivate(ComponentContext context) throws Exception {
        if (this.hotDeployerEnabler != null) {
            this.hotDeployerEnabler.stopHotDeployer();
        }
    }

    private void initialiseHotDeployer() {
        int deployerTimeout = Integer.valueOf(this.kernelConfig.getProperty("deployer.timeout"));
        String pickupDirectory = this.kernelConfig.getProperty("deployer.pickupDirectory");
        StandardDeployerConfiguration deployerConfiguration = new StandardDeployerConfiguration(deployerTimeout, new File(pickupDirectory));
        this.hotDeployerEnabler = new HotDeployerEnabler(this, deployerConfiguration, this.eventLogger);
        this.hotDeployerEnabler.startHotDeployer();
    }

    public DeploymentIdentity deploy(URI uri) throws DeploymentException {
        boolean isThereSuitableDeployer = false;
        for (SimpleDeployer deployer : this.simpleDeployers) {
            if (!deployer.canServeFileType(this.getFileTypeFromUri(uri))) continue;
            isThereSuitableDeployer = true;
            if (!deployer.isDeployFileValid(new File(uri))) {
                this.eventLogger.log((LogEvent)NanoDeployerLogEvents.NANO_INVALID_FILE, new Object[0]);
                continue;
            }
            if (deployer.isDeployed(uri)) {
                deployer.update(uri);
                continue;
            }
            deployer.deploy(uri);
        }
        if (!isThereSuitableDeployer) {
            ArrayList<String> acceptedTypes = new ArrayList<String>();
            for (SimpleDeployer deployer : this.simpleDeployers) {
                acceptedTypes.addAll(deployer.getAcceptedFileTypes());
            }
            this.eventLogger.log((LogEvent)NanoDeployerLogEvents.NANO_UNRECOGNIZED_TYPE, new Object[]{uri, acceptedTypes});
        }
        return null;
    }

    public void undeploy(DeploymentIdentity deploymentIdentity) throws DeploymentException {
        if (this.bundleContext != null) {
            String symbolicName = deploymentIdentity.getSymbolicName();
            String version = deploymentIdentity.getVersion();
            ArrayList<Bundle> existingBundles = new ArrayList<Bundle>();
            Bundle[] bundleArray = this.bundleContext.getBundles();
            int n = bundleArray.length;
            int n2 = 0;
            while (n2 < n) {
                Bundle bundle = bundleArray[n2];
                if (bundle.getSymbolicName().equals(symbolicName) && bundle.getVersion().toString().equals(version)) {
                    existingBundles.add(bundle);
                }
                ++n2;
            }
            if (existingBundles.size() > 1) {
                this.logger.warn("Multiple bundles matching the marked for uninstall symbolicName-version pair. List of all matches: " + existingBundles.toArray(new Bundle[existingBundles.size()]).toString());
                this.logger.warn("Uninstalling the last-installed matching bundle " + ((Bundle)existingBundles.get(existingBundles.size() - 1)).toString());
            }
            boolean isThereSuitableDeployer = false;
            for (SimpleDeployer deployer : this.simpleDeployers) {
                if (!deployer.canServeFileType(deploymentIdentity.getType())) continue;
                isThereSuitableDeployer = true;
                deployer.undeploy((Bundle)existingBundles.get(0));
            }
            if (!isThereSuitableDeployer) {
                this.defaultDeployer.undeploy((Bundle)existingBundles.get(0));
            }
        }
    }

    public DeploymentIdentity getDeploymentIdentity(URI uri) {
        for (SimpleDeployer deployer : this.simpleDeployers) {
            if (!deployer.canServeFileType(this.getFileTypeFromUri(uri))) continue;
            return deployer.getDeploymentIdentity(uri);
        }
        return null;
    }

    public boolean isDeployed(URI uri) {
        for (SimpleDeployer deployer : this.simpleDeployers) {
            if (!deployer.canServeFileType(this.getFileTypeFromUri(uri))) continue;
            return deployer.isDeployed(uri);
        }
        return false;
    }

    private String getFileTypeFromUri(URI uri) {
        String path = uri.toString();
        return path.substring(path.lastIndexOf(".") + 1);
    }

    public DeploymentIdentity deploy(URI uri, DeploymentOptions options) throws DeploymentException {
        return this.deploy(uri);
    }

    public DeploymentIdentity deploy(String type, String name, Version version) throws DeploymentException {
        throw new UnsupportedOperationException("Not supported in Virgo Nano.");
    }

    public DeploymentIdentity deploy(String type, String name, Version version, DeploymentOptions options) throws DeploymentException {
        throw new UnsupportedOperationException("Not supported in Virgo Nano.");
    }

    public void undeploy(String applicationSymbolicName, String version) throws DeploymentException {
        throw new UnsupportedOperationException("Not supported in Virgo Nano.");
    }

    public DeploymentIdentity install(URI uri, DeploymentOptions options) throws DeploymentException {
        throw new UnsupportedOperationException("Not supported in Virgo Nano.");
    }

    public DeploymentIdentity install(URI uri) throws DeploymentException {
        throw new UnsupportedOperationException("Not supported in Virgo Nano.");
    }

    public void undeploy(String type, String name, String version) throws DeploymentException {
        throw new UnsupportedOperationException("Not supported in Virgo Nano.");
    }

    public void undeploy(DeploymentIdentity deploymentIdentity, boolean deleted) throws DeploymentException {
        throw new UnsupportedOperationException("Not supported in Virgo Nano.");
    }

    public DeploymentIdentity refresh(URI uri, String symbolicName) throws DeploymentException {
        throw new UnsupportedOperationException("Not supported in Virgo Nano.");
    }

    public void refreshBundle(String bundleSymbolicName, String bundleVersion) throws DeploymentException {
        throw new UnsupportedOperationException("Not supported in Virgo Nano.");
    }

    public DeploymentIdentity[] getDeploymentIdentities() {
        throw new UnsupportedOperationException("Not supported in Virgo Nano.");
    }

    public void bindEventLogger(EventLogger logger) {
        this.eventLogger = logger;
    }

    public void unbindEventLogger(EventLogger logger) {
        this.eventLogger = null;
    }

    public void bindKernelConfig(KernelConfig config) {
        this.kernelConfig = config;
    }

    public void unbindKernelConfig(KernelConfig config) {
        this.kernelConfig = null;
    }

    public void bindPackageAdmin(PackageAdmin packageAdmin) {
        this.packageAdmin = packageAdmin;
    }

    public void unbindPackageAdmin(PackageAdmin packageAdmin) {
        this.packageAdmin = null;
    }

    public void bindSimpleDeployer(SimpleDeployer deployer) {
        this.simpleDeployers.add(deployer);
    }

    public void unbindSimpleDeployer(SimpleDeployer deployer) {
        this.simpleDeployers.remove(deployer);
    }
}

