/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.portlet.mvc.annotation;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.portlet.ClientDataRequest;
import javax.portlet.PortletRequest;
import org.springframework.http.MediaType;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.portlet.util.PortletUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class PortletAnnotationMappingUtils {
    PortletAnnotationMappingUtils() {
    }

    public static boolean validateModeMapping(String[] modes, String[] typeLevelModes) {
        if (!ObjectUtils.isEmpty((Object[])modes) && !ObjectUtils.isEmpty((Object[])typeLevelModes)) {
            String[] stringArray = modes;
            int n = modes.length;
            int n2 = 0;
            while (n2 < n) {
                String mode = stringArray[n2];
                boolean match = false;
                String[] stringArray2 = typeLevelModes;
                int n3 = typeLevelModes.length;
                int n4 = 0;
                while (n4 < n3) {
                    String typeLevelMode = stringArray2[n4];
                    if (mode.equalsIgnoreCase(typeLevelMode)) {
                        match = true;
                    }
                    ++n4;
                }
                if (!match) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    public static boolean checkRequestMethod(RequestMethod[] methods, PortletRequest request) {
        if (methods.length == 0) {
            return true;
        }
        if (!(request instanceof ClientDataRequest)) {
            return false;
        }
        String method = ((ClientDataRequest)request).getMethod();
        RequestMethod[] requestMethodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            RequestMethod candidate = requestMethodArray[n2];
            if (method.equals(candidate.name())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean checkRequestMethod(Set<String> methods, PortletRequest request) {
        if (!methods.isEmpty()) {
            if (!(request instanceof ClientDataRequest)) {
                return false;
            }
            String method = ((ClientDataRequest)request).getMethod();
            if (!methods.contains(method)) {
                return false;
            }
        }
        return true;
    }

    public static boolean checkParameters(String[] params, PortletRequest request) {
        if (!ObjectUtils.isEmpty((Object[])params)) {
            String[] stringArray = params;
            int n = params.length;
            int n2 = 0;
            while (n2 < n) {
                String param = stringArray[n2];
                int separator = param.indexOf(61);
                if (separator == -1) {
                    if (param.startsWith("!") ? PortletUtils.hasSubmitParameter(request, param.substring(1)) : !PortletUtils.hasSubmitParameter(request, param)) {
                        return false;
                    }
                } else {
                    String key = param.substring(0, separator);
                    String value = param.substring(separator + 1);
                    if (!value.equals(request.getParameter(key))) {
                        return false;
                    }
                }
                ++n2;
            }
        }
        return true;
    }

    public static boolean checkHeaders(String[] headers, PortletRequest request) {
        if (!ObjectUtils.isEmpty((Object[])headers)) {
            String[] stringArray = headers;
            int n = headers.length;
            int n2 = 0;
            while (n2 < n) {
                String header = stringArray[n2];
                int separator = header.indexOf(61);
                if (separator == -1) {
                    if (header.startsWith("!") ? request.getProperty(header.substring(1)) != null : request.getProperty(header) == null) {
                        return false;
                    }
                } else {
                    String key = header.substring(0, separator);
                    String value = header.substring(separator + 1);
                    if (PortletAnnotationMappingUtils.isMediaTypeHeader(key)) {
                        List requestMediaTypes = MediaType.parseMediaTypes((String)request.getProperty(key));
                        List valueMediaTypes = MediaType.parseMediaTypes((String)value);
                        boolean found = false;
                        Iterator valIter = valueMediaTypes.iterator();
                        while (valIter.hasNext() && !found) {
                            MediaType valueMediaType = (MediaType)valIter.next();
                            Iterator reqIter = requestMediaTypes.iterator();
                            while (reqIter.hasNext() && !found) {
                                MediaType requestMediaType = (MediaType)reqIter.next();
                                if (!valueMediaType.includes(requestMediaType)) continue;
                                found = true;
                            }
                        }
                        if (!found) {
                            return false;
                        }
                    } else if (!value.equals(request.getProperty(key))) {
                        return false;
                    }
                }
                ++n2;
            }
        }
        return true;
    }

    private static boolean isMediaTypeHeader(String headerName) {
        return "Accept".equalsIgnoreCase(headerName) || "Content-Type".equalsIgnoreCase(headerName);
    }
}

