/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.console.jaas;

import java.security.Principal;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.equinox.console.jaas.RolePrincipal;

public class UserPrincipal
implements Principal {
    private String username;
    private char[] password;
    private Set<RolePrincipal> rolePrincipals = new HashSet<RolePrincipal>();

    public UserPrincipal(String username, String password) {
        this.username = username;
        this.password = new char[password.length()];
        System.arraycopy(password.toCharArray(), 0, this.password, 0, this.password.length);
    }

    @Override
    public String getName() {
        return this.username;
    }

    public boolean authenticate(char[] password) {
        if (password == null) {
            return false;
        }
        if (this.password == null) {
            return false;
        }
        if (this.password.length != password.length) {
            return false;
        }
        int i = 0;
        while (i < this.password.length) {
            if (this.password[i] != password[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public Set<RolePrincipal> getRoles() {
        return this.rolePrincipals;
    }

    public synchronized void addRole(RolePrincipal rolePrincipal) {
        this.rolePrincipals.add(rolePrincipal);
    }

    @Override
    public boolean equals(Object userPrincipal) {
        if (userPrincipal == null) {
            return false;
        }
        if (this == userPrincipal) {
            return true;
        }
        if (!(userPrincipal instanceof UserPrincipal)) {
            return false;
        }
        UserPrincipal otherUser = (UserPrincipal)userPrincipal;
        if (this.username != null ? !this.username.equals(otherUser.username) : otherUser.username != null) {
            return false;
        }
        if (this.password != null) {
            if (otherUser.password == null) {
                return false;
            }
            if (this.password.length != otherUser.password.length) {
                return false;
            }
            int i = 0;
            while (i < this.password.length) {
                if (this.password[i] != otherUser.password[i]) {
                    return false;
                }
                ++i;
            }
        } else if (otherUser.username != null) {
            return false;
        }
        return !(this.rolePrincipals != null ? !this.rolePrincipals.equals(otherUser.rolePrincipals) : otherUser.rolePrincipals != null);
    }

    public void destroy() {
        int i = 0;
        while (i < this.password.length) {
            this.password[i] = 32;
            ++i;
        }
        this.password = null;
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 73 * result + (this.username == null ? 0 : this.username.hashCode());
        result = 73 * result + (this.password == null ? 0 : new String(this.password).hashCode());
        result = 73 * result + (this.rolePrincipals == null ? 0 : this.rolePrincipals.hashCode());
        return result;
    }
}

