/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr303;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.validation.ValidationException;
import org.apache.bval.jsr303.UnknownPropertyException;
import org.apache.bval.model.MetaBean;
import org.apache.bval.model.MetaProperty;
import org.apache.bval.util.PropertyAccess;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class NestedMetaProperty {
    private MetaBean metaBean;
    private MetaProperty metaProperty;
    private final String propertyPath;
    private boolean nested;
    private Object value;

    public NestedMetaProperty(String path, Object value) {
        this.propertyPath = path;
        this.value = value;
    }

    void parse() {
        try {
            StringTokenizer tokens = new StringTokenizer(this.propertyPath, ".[]", true);
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken();
                if ("[".equals(token)) {
                    String sindex = tokens.nextToken();
                    int idx = Integer.parseInt(sindex);
                    token = tokens.nextToken();
                    if (!"]".equals(token)) {
                        throw new ValidationException("']' missing, invalid property format: " + this.propertyPath);
                    }
                    this.useIndexedValue(idx);
                    this.resolveMetaBean();
                    continue;
                }
                if (".".equals(token)) continue;
                MetaProperty mp = this.getMetaBean().getProperty(token);
                if (mp == null) {
                    throw new UnknownPropertyException("unknown property '" + token + "' in " + this.getMetaBean().getId());
                }
                if (this.getValue() != null) {
                    this.setValue(PropertyAccess.getProperty(this.getValue(), token));
                }
                this.setMetaProperty(mp);
                this.resolveMetaBean();
            }
        }
        catch (ValidationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ValidationException("invalid property format: " + this.propertyPath, (Throwable)ex);
        }
    }

    public MetaProperty getMetaProperty() {
        return this.metaProperty;
    }

    public String getPropertyPath() {
        return this.propertyPath;
    }

    public boolean isNested() {
        return this.nested;
    }

    public void setMetaProperty(MetaProperty aMetaProperty) {
        if (this.metaProperty != null) {
            this.nested = true;
        }
        this.metaProperty = aMetaProperty;
    }

    public MetaBean getMetaBean() {
        return this.metaBean;
    }

    public void setMetaBean(MetaBean metaBean) {
        this.metaBean = metaBean;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    private void useIndexedValue(int idx) {
        this.setValue(this.getAtIndex(this.getValue(), idx));
    }

    private Object getAtIndex(Object value, int idx) {
        if (value == null) {
            return null;
        }
        if (value instanceof Iterable) {
            Iterator iter = ((Iterable)value).iterator();
            for (int i = 0; i <= idx; ++i) {
                value = iter.next();
            }
            return value;
        }
        if (value.getClass().isArray()) {
            return this.getAtIndex(Arrays.asList(value), idx);
        }
        throw new ValidationException("cannot access indexed value from " + value);
    }

    static Type typeOf(Member member) {
        if (member instanceof Field) {
            return ((Field)member).getGenericType();
        }
        if (member instanceof Method) {
            return ((Method)member).getGenericReturnType();
        }
        throw new IllegalArgumentException("Member " + member + " is neither a field nor a method");
    }

    static Type getIndexedType(Type type) {
        Type indexedType = type;
        if (NestedMetaProperty.isCollection(type) && type instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)type;
            Class<? extends Collection<?>> collectionClass = NestedMetaProperty.getCollectionClass(type);
            if (Collection.class.isAssignableFrom(collectionClass)) {
                indexedType = paramType.getActualTypeArguments()[0];
            } else if (Map.class.isAssignableFrom(collectionClass)) {
                indexedType = paramType.getActualTypeArguments()[1];
            }
        } else if (NestedMetaProperty.isArray(type) && type instanceof GenericArrayType) {
            GenericArrayType arrayTye = (GenericArrayType)type;
            indexedType = arrayTye.getGenericComponentType();
        }
        return indexedType;
    }

    static Class<? extends Collection<?>> getCollectionClass(Type type) {
        if (type instanceof Class && NestedMetaProperty.isCollectionClass((Class)type)) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return NestedMetaProperty.getCollectionClass(((ParameterizedType)type).getRawType());
        }
        if (type instanceof WildcardType) {
            Type[] upperBounds = ((WildcardType)type).getUpperBounds();
            if (upperBounds.length == 0) {
                return null;
            }
            return NestedMetaProperty.getCollectionClass(upperBounds[0]);
        }
        return null;
    }

    static boolean isArray(Type type) {
        if (type instanceof Class) {
            return ((Class)type).isArray();
        }
        return type instanceof GenericArrayType;
    }

    static boolean isCollection(Type type) {
        return NestedMetaProperty.getCollectionClass(type) != null;
    }

    static boolean isCollectionClass(Class<?> clazz) {
        return Collection.class.isAssignableFrom(clazz) || Map.class.isAssignableFrom(clazz);
    }

    private void resolveMetaBean() {
        if (this.metaProperty.getMetaBean() == null) {
            return;
        }
        if (this.getValue() != null) {
            this.metaBean = this.metaProperty.getMetaBean().resolveMetaBean(this.getValue());
        } else {
            Type type;
            AccessibleObject member = null;
            try {
                member = this.metaBean.getBeanClass().getDeclaredField(this.metaProperty.getName());
            }
            catch (NoSuchFieldException e) {
                String getter = "get" + StringUtils.capitalize((String)this.metaProperty.getName());
                try {
                    member = this.metaBean.getBeanClass().getDeclaredMethod(getter, new Class[0]);
                }
                catch (NoSuchMethodException e1) {
                    try {
                        member = this.metaBean.getBeanClass().getField(this.metaProperty.getName());
                    }
                    catch (NoSuchFieldException e2) {
                        try {
                            member = this.metaBean.getBeanClass().getMethod(getter, new Class[0]);
                        }
                        catch (NoSuchMethodException e3) {
                            // empty catch block
                        }
                    }
                }
            }
            if (member != null && (type = NestedMetaProperty.getIndexedType(NestedMetaProperty.typeOf(member))) != null) {
                this.metaBean = this.metaProperty.getMetaBean().resolveMetaBean(type);
            }
        }
    }
}

