/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.cli.SystemExitException;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.DeploymentLoader;
import org.apache.openejb.config.ValidationError;
import org.apache.openejb.config.ValidationException;
import org.apache.openejb.config.ValidationResults;
import org.apache.openejb.config.ValidationRule;
import org.apache.openejb.config.rules.CheckAssemblyBindings;
import org.apache.openejb.config.rules.CheckAsynchronous;
import org.apache.openejb.config.rules.CheckCallbacks;
import org.apache.openejb.config.rules.CheckClasses;
import org.apache.openejb.config.rules.CheckDependsOn;
import org.apache.openejb.config.rules.CheckDescriptorLocation;
import org.apache.openejb.config.rules.CheckInjectionPointUsage;
import org.apache.openejb.config.rules.CheckInjectionTargets;
import org.apache.openejb.config.rules.CheckMethods;
import org.apache.openejb.config.rules.CheckPersistenceRefs;
import org.apache.openejb.config.rules.CheckUserTransactionRefs;
import org.apache.openejb.util.Messages;
import org.apache.openejb.util.OpenEjbVersion;

public class AppValidator {
    protected static final Messages _messages = new Messages("org.apache.openejb.config.rules");
    int LEVEL = 2;
    boolean PRINT_XML = false;
    boolean PRINT_WARNINGS = true;
    boolean PRINT_COUNT = false;
    private List<ValidationResults> sets = new ArrayList<ValidationResults>();

    public AppValidator() throws OpenEJBException {
    }

    public AppValidator(int LEVEL, boolean PRINT_XML, boolean PRINT_WARNINGS, boolean PRINT_COUNT) {
        this.LEVEL = LEVEL;
        this.PRINT_XML = PRINT_XML;
        this.PRINT_WARNINGS = PRINT_WARNINGS;
        this.PRINT_COUNT = PRINT_COUNT;
    }

    public void addValidationResults(ValidationResults set) {
        this.sets.add(set);
    }

    public ValidationResults[] getValidationResultsSets() {
        ValidationResults[] ejbSets = new ValidationResults[this.sets.size()];
        return this.sets.toArray(ejbSets);
    }

    public AppModule validate(AppModule appModule) {
        try {
            ValidationRule[] rules = this.getValidationRules();
            for (int i = 0; i < rules.length; ++i) {
                rules[i].validate(appModule);
            }
        }
        catch (Throwable e) {
            e.printStackTrace(System.out);
            ValidationError err = new ValidationError("cannot.validate");
            err.setCause(e);
            err.setDetails(e.getMessage());
            appModule.getValidation().addError(err);
        }
        return appModule;
    }

    protected ValidationRule[] getValidationRules() {
        ValidationRule[] rules = new ValidationRule[]{new CheckClasses(), new CheckMethods(), new CheckCallbacks(), new CheckAssemblyBindings(), new CheckInjectionTargets(), new CheckInjectionPointUsage(), new CheckPersistenceRefs(), new CheckDependsOn(), new CheckUserTransactionRefs(), new CheckAsynchronous(), new CheckDescriptorLocation()};
        return rules;
    }

    public void printResults(ValidationResults set) {
        if (!(set.hasErrors() || set.hasFailures() || this.PRINT_WARNINGS && set.hasWarnings())) {
            return;
        }
        System.out.println("------------------------------------------");
        System.out.println("JAR " + set.getName());
        System.out.println("                                          ");
        this.printValidationExceptions(set.getErrors());
        this.printValidationExceptions(set.getFailures());
        if (this.PRINT_WARNINGS) {
            this.printValidationExceptions(set.getWarnings());
        }
    }

    protected void printValidationExceptions(ValidationException[] exceptions) {
        for (int i = 0; i < exceptions.length; ++i) {
            System.out.print(" ");
            System.out.print(exceptions[i].getPrefix());
            System.out.print(" ... ");
            if (!(exceptions[i] instanceof ValidationError)) {
                System.out.print(exceptions[i].getComponentName());
                System.out.print(": ");
            }
            if (this.LEVEL > 2) {
                System.out.println(exceptions[i].getMessage(1));
                System.out.println();
                System.out.print('\t');
                System.out.println(exceptions[i].getMessage(this.LEVEL));
                System.out.println();
                continue;
            }
            System.out.println(exceptions[i].getMessage(this.LEVEL));
        }
        if (this.PRINT_COUNT && exceptions.length > 0) {
            System.out.println();
            System.out.print(" " + exceptions.length + " ");
            System.out.println(exceptions[0].getCategory());
            System.out.println();
        }
    }

    public void printResultsXML(ValidationResults set) {
        if (!(set.hasErrors() || set.hasFailures() || this.PRINT_WARNINGS && set.hasWarnings())) {
            return;
        }
        System.out.println("<jar>");
        System.out.print("  <path>");
        System.out.print(set.getName());
        System.out.println("</path>");
        this.printValidationExceptionsXML(set.getErrors());
        this.printValidationExceptionsXML(set.getFailures());
        if (this.PRINT_WARNINGS) {
            this.printValidationExceptionsXML(set.getWarnings());
        }
        System.out.println("</jar>");
    }

    protected void printValidationExceptionsXML(ValidationException[] exceptions) {
        for (int i = 0; i < exceptions.length; ++i) {
            System.out.print("    <");
            System.out.print(exceptions[i].getPrefix());
            System.out.println(">");
            if (!(exceptions[i] instanceof ValidationError)) {
                System.out.print("      <ejb-name>");
                System.out.print(exceptions[i].getComponentName());
                System.out.println("</ejb-name>");
            }
            System.out.print("      <summary>");
            System.out.print(exceptions[i].getMessage(1));
            System.out.println("</summary>");
            System.out.println("      <description><![CDATA[");
            System.out.println(exceptions[i].getMessage(3));
            System.out.println("]]></description>");
            System.out.print("    </");
            System.out.print(exceptions[i].getPrefix());
            System.out.println(">");
        }
    }

    public void displayResults(ValidationResults[] sets) {
        if (this.PRINT_XML) {
            System.out.println("<results>");
            for (int i = 0; i < sets.length; ++i) {
                this.printResultsXML(sets[i]);
            }
            System.out.println("</results>");
        } else {
            int i;
            for (i = 0; i < sets.length; ++i) {
                this.printResults(sets[i]);
            }
            for (i = 0; i < sets.length; ++i) {
                if (!sets[i].hasErrors() && !sets[i].hasFailures()) continue;
                if (this.LEVEL < 3) {
                    System.out.println();
                    System.out.println("For more details, use the -vvv option");
                }
                i = sets.length;
            }
        }
    }

    public static void main(String[] args) throws SystemExitException {
        PosixParser parser = new PosixParser();
        Options options = new Options();
        options.addOption(AppValidator.option("v", "version", "cmd.validate.opt.version"));
        options.addOption(AppValidator.option("h", "help", "cmd.validate.opt.help"));
        CommandLine line = null;
        try {
            line = parser.parse(options, args);
        }
        catch (ParseException exp) {
            AppValidator.help(options);
            throw new SystemExitException(-1);
        }
        if (line.hasOption("help")) {
            AppValidator.help(options);
            return;
        }
        if (line.hasOption("version")) {
            OpenEjbVersion.get().print(System.out);
            return;
        }
        if (line.getArgList().size() == 0) {
            System.out.println("Must specify an module id.");
            AppValidator.help(options);
        }
        DeploymentLoader deploymentLoader = new DeploymentLoader();
        try {
            AppValidator validator = new AppValidator();
            for (Object obj : line.getArgList()) {
                String module = (String)obj;
                File file = new File(module);
                AppModule appModule = deploymentLoader.load(file);
                validator.validate(appModule);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void help(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("validate [options] <file> [<file>...]", "\n" + AppValidator.i18n("cmd.validate.description"), options, "\n");
    }

    private static Option option(String shortOpt, String longOpt, String description) {
        OptionBuilder.withLongOpt((String)longOpt);
        OptionBuilder.withDescription((String)AppValidator.i18n(description));
        return OptionBuilder.create((String)shortOpt);
    }

    private static Option option(String shortOpt, String longOpt, String argName, String description) {
        OptionBuilder.withLongOpt((String)longOpt);
        OptionBuilder.withArgName((String)argName);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)AppValidator.i18n(description));
        return OptionBuilder.create((String)shortOpt);
    }

    private static String i18n(String key) {
        return _messages.format(key);
    }
}

