/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.util;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Messages {
    private static Hashtable _rbBundles = new Hashtable();
    private static Hashtable _rbFormats = new Hashtable();
    private static Locale _globalLocale;
    private ResourceBundle _messages;
    private Hashtable _formats;
    private Locale _locale;
    private String _resourceName;

    public Messages(Class clazz) {
        this(Messages.packageName(clazz));
    }

    private static String packageName(Class clazz) {
        String name = clazz.getName();
        return name.substring(0, name.lastIndexOf("."));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Messages(String resourceName) {
        Class<Messages> clazz = Messages.class;
        synchronized (Messages.class) {
            this._locale = _globalLocale;
            this._resourceName = resourceName + ".Messages";
            ResourceBundle rb = (ResourceBundle)_rbBundles.get(this._resourceName);
            if (rb == null) {
                this.init();
            } else {
                this._messages = rb;
                this._formats = (Hashtable)_rbFormats.get(this._resourceName);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    protected void init() {
        try {
            this._messages = this._locale == null ? ResourceBundle.getBundle(this._resourceName) : ResourceBundle.getBundle(this._resourceName, this._locale);
        }
        catch (Exception except) {
            this._messages = new EmptyResourceBundle();
        }
        this._formats = new Hashtable();
        _rbBundles.put(this._resourceName, this._messages);
        _rbFormats.put(this._resourceName, this._formats);
    }

    public String format(String message) {
        return this.message(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public String format(String message, Object ... args) {
        if (this._locale != _globalLocale) {
            Class<Messages> clazz = Messages.class;
            // MONITORENTER : org.apache.openejb.util.Messages.class
            this.init();
            // MONITOREXIT : clazz
        }
        try {
            String msg;
            MessageFormat mf = (MessageFormat)this._formats.get(message);
            if (mf != null) return mf.format(args);
            try {
                msg = this._messages.getString(message);
            }
            catch (MissingResourceException except) {
                String string;
                StringBuilder stringBuilder = new StringBuilder().append(message);
                if (args != null) {
                    string = " " + Arrays.toString(args);
                    return stringBuilder.append(string).toString();
                }
                string = "";
                return stringBuilder.append(string).toString();
            }
            mf = new MessageFormat(msg);
            this._formats.put(message, mf);
            return mf.format(args);
        }
        catch (Exception except) {
            return "An internal error occured while processing message " + message;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public String message(String message) {
        if (this._locale != _globalLocale) {
            Class<Messages> clazz = Messages.class;
            // MONITORENTER : org.apache.openejb.util.Messages.class
            this.init();
            // MONITOREXIT : clazz
        }
        try {
            return this._messages.getString(message);
        }
        catch (MissingResourceException except) {
            return message;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLocale(Locale locale) {
        Class<Messages> clazz = Messages.class;
        synchronized (Messages.class) {
            _globalLocale = locale;
            _rbBundles = new Hashtable();
            _rbFormats = new Hashtable();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    static {
        Messages.setLocale(Locale.getDefault());
    }

    private static final class EmptyResourceBundle
    extends ResourceBundle
    implements Enumeration {
        private EmptyResourceBundle() {
        }

        public Enumeration getKeys() {
            return this;
        }

        @Override
        protected Object handleGetObject(String name) {
            return "[Missing message " + name + "]";
        }

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            return null;
        }
    }
}

