/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.nano.shutdown;

import org.eclipse.virgo.nano.shutdown.ShutdownCommand;

final class ShutdownCommandParser {
    private static final String OPTION_DOMAIN = "-domain";
    private static final String OPTION_IMMEDIATE = "-immediate";
    private static final String OPTION_JMXPORT = "-jmxport";
    private static final String OPTION_PASSWORD = "-password";
    private static final String OPTION_USERNAME = "-username";

    ShutdownCommandParser() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static ShutdownCommand parse(String ... args) {
        ShutdownCommand command = new ShutdownCommand();
        if (args.length <= 0) return command;
        int i = 0;
        while (i < args.length) {
            if (args[i].equals(OPTION_USERNAME)) {
                if (i >= args.length - 1) return null;
                command.setUsername(args[++i]);
            } else if (args[i].equals(OPTION_PASSWORD)) {
                if (i >= args.length - 1) return null;
                command.setPassword(args[++i]);
            } else if (args[i].equals(OPTION_JMXPORT)) {
                if (i >= args.length - 1) return null;
                try {
                    command.setPort(Integer.parseInt(args[++i]));
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
            } else if (args[i].equals(OPTION_IMMEDIATE)) {
                command.setImmediate(true);
            } else {
                if (!args[i].equals(OPTION_DOMAIN)) return null;
                if (i >= args.length - 1) return null;
                command.setDomain(args[++i]);
            }
            ++i;
        }
        return command;
    }
}

