/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.plus.jaas.spi;

import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import org.eclipse.jetty.plus.jaas.spi.AbstractLoginModule;
import org.eclipse.jetty.plus.jaas.spi.UserInfo;
import org.eclipse.jetty.security.PropertyUserStore;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.security.Credential;

public class PropertyFileLoginModule
extends AbstractLoginModule {
    public static final String DEFAULT_FILENAME = "realm.properties";
    private static final Logger LOG = Log.getLogger(PropertyFileLoginModule.class);
    private static Map<String, PropertyUserStore> _propertyUserStores = new HashMap<String, PropertyUserStore>();
    private int _refreshInterval = 0;
    private String _filename = "realm.properties";

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        this.setupPropertyUserStore(options);
    }

    private void setupPropertyUserStore(Map<String, ?> options) {
        if (_propertyUserStores.get(this._filename) == null) {
            this.parseConfig(options);
            PropertyUserStore _propertyUserStore = new PropertyUserStore();
            _propertyUserStore.setConfig(this._filename);
            _propertyUserStore.setRefreshInterval(this._refreshInterval);
            LOG.debug("setupPropertyUserStore: Starting new PropertyUserStore. PropertiesFile: " + this._filename + " refreshInterval: " + this._refreshInterval, new Object[0]);
            try {
                _propertyUserStore.start();
            }
            catch (Exception e) {
                LOG.warn("Exception while starting propertyUserStore: ", (Throwable)e);
            }
            _propertyUserStores.put(this._filename, _propertyUserStore);
        }
    }

    private void parseConfig(Map<String, ?> options) {
        this._filename = (String)options.get("file") != null ? (String)options.get("file") : DEFAULT_FILENAME;
        String refreshIntervalString = (String)options.get("refreshInterval");
        this._refreshInterval = refreshIntervalString == null ? this._refreshInterval : Integer.parseInt(refreshIntervalString);
    }

    @Override
    public UserInfo getUserInfo(String userName) throws Exception {
        PropertyUserStore propertyUserStore = _propertyUserStores.get(this._filename);
        if (propertyUserStore == null) {
            throw new IllegalStateException("PropertyUserStore should never be null here!");
        }
        UserIdentity userIdentity = propertyUserStore.getUserIdentity(userName);
        if (userIdentity == null) {
            return null;
        }
        Set<Principal> principals = userIdentity.getSubject().getPrincipals();
        ArrayList<String> roles = new ArrayList<String>();
        for (Principal principal : principals) {
            roles.add(principal.getName());
        }
        Credential credential = (Credential)userIdentity.getSubject().getPrivateCredentials().iterator().next();
        LOG.debug("Found: " + userName + " in PropertyUserStore", new Object[0]);
        return new UserInfo(userName, credential, roles);
    }
}

