/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.MethodExpression;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.ProjectStage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.UIViewParameter;
import javax.faces.component.UniqueIdVendor;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ExceptionQueuedEvent;
import javax.faces.event.ExceptionQueuedEventContext;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.event.PostConstructViewMapEvent;
import javax.faces.event.PreDestroyViewMapEvent;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import javax.faces.view.ViewDeclarationLanguage;
import javax.faces.view.ViewMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIViewRoot
extends UIComponentBase
implements UniqueIdVendor {
    public static final String METADATA_FACET_NAME = "javax_faces_metadata";
    public static final String VIEW_PARAMETERS_KEY = "javax.faces.component.VIEW_PARAMETERS_KEY";
    public static final String COMPONENT_TYPE = "javax.faces.ViewRoot";
    public static final String COMPONENT_FAMILY = "javax.faces.ViewRoot";
    public static final String UNIQUE_ID_PREFIX = "j_id";
    private static Lifecycle lifecycle;
    private static final Logger LOGGER;
    private static final String LOCATION_IDENTIFIER_PREFIX = "javax_faces_location_";
    private static final Map<String, String> LOCATION_IDENTIFIER_MAP;
    private boolean skipPhase;
    private boolean beforeMethodException;
    private ListIterator<PhaseListener> phaseListenerIterator;
    private List<List<FacesEvent>> events = null;
    private Map<String, Object> viewScope = null;
    Map<Class<? extends SystemEvent>, List<SystemEventListener>> viewListeners;
    private Object[] values;

    public UIViewRoot() {
        this.setRendererType(null);
        this.setId(this.createUniqueId());
    }

    @Override
    public boolean isInView() {
        return true;
    }

    @Override
    public void setInView(boolean isInView) {
    }

    @Override
    public String getFamily() {
        return "javax.faces.ViewRoot";
    }

    public String getRenderKitId() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.renderKitId));
    }

    public void setRenderKitId(String renderKitId) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.renderKitId), renderKitId);
    }

    public String getViewId() {
        return (String)this.getStateHelper().get((Serializable)((Object)PropertyKeys.viewId));
    }

    public void setViewId(String viewId) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.viewId), viewId);
    }

    public MethodExpression getBeforePhaseListener() {
        return (MethodExpression)this.getStateHelper().get((Serializable)((Object)PropertyKeys.beforePhase));
    }

    public void setBeforePhaseListener(MethodExpression newBeforePhase) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.beforePhase), newBeforePhase);
    }

    public MethodExpression getAfterPhaseListener() {
        return (MethodExpression)this.getStateHelper().get((Serializable)((Object)PropertyKeys.afterPhase));
    }

    public void setAfterPhaseListener(MethodExpression newAfterPhase) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.afterPhase), newAfterPhase);
    }

    public void removePhaseListener(PhaseListener toRemove) {
        this.getStateHelper().remove((Serializable)((Object)PropertyKeys.phaseListeners), toRemove);
    }

    public void addPhaseListener(PhaseListener newPhaseListener) {
        this.getStateHelper().add((Serializable)((Object)PropertyKeys.phaseListeners), newPhaseListener);
    }

    public List<PhaseListener> getPhaseListeners() {
        List result = (List)this.getStateHelper().get((Serializable)((Object)PropertyKeys.phaseListeners));
        return result != null ? Collections.unmodifiableList(result) : Collections.unmodifiableList(Collections.emptyList());
    }

    public void addComponentResource(FacesContext context, UIComponent componentResource) {
        this.addComponentResource(context, componentResource, null);
    }

    public void addComponentResource(FacesContext context, UIComponent componentResource, String target) {
        Map<String, Object> attributes = componentResource.getAttributes();
        if (target == null) {
            target = (String)attributes.get("target");
        }
        if (target == null) {
            target = "head";
        }
        List<UIComponent> facetChildren = this.getComponentResources(context, target, true);
        String id = componentResource.getId();
        if (id != null) {
            for (UIComponent c : facetChildren) {
                if (!id.equals(c.getId())) continue;
                facetChildren.remove(c);
            }
        }
        facetChildren.add(componentResource);
    }

    public List<UIComponent> getComponentResources(FacesContext context, String target) {
        if (target == null) {
            throw new NullPointerException();
        }
        List<UIComponent> resources = this.getComponentResources(context, target, false);
        return resources != null ? resources : Collections.emptyList();
    }

    public void removeComponentResource(FacesContext context, UIComponent componentResource) {
        this.removeComponentResource(context, componentResource, null);
    }

    public void removeComponentResource(FacesContext context, UIComponent componentResource, String target) {
        List<UIComponent> facetChildren;
        Map<String, Object> attributes = componentResource.getAttributes();
        if (target == null) {
            target = (String)attributes.get("target");
        }
        if (target == null) {
            target = "head";
        }
        if ((facetChildren = this.getComponentResources(context, target, false)) != null) {
            facetChildren.remove(componentResource);
        }
    }

    @Override
    public void queueEvent(FacesEvent event) {
        if (event == null) {
            throw new NullPointerException();
        }
        if (this.events == null) {
            int len = PhaseId.VALUES.size();
            ArrayList<List<FacesEvent>> events = new ArrayList<List<FacesEvent>>(len);
            for (int i = 0; i < len; ++i) {
                events.add(new ArrayList(5));
            }
            this.events = events;
        }
        this.events.get(event.getPhaseId().getOrdinal()).add(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void broadcastEvents(FacesContext context, PhaseId phaseId) {
        boolean hasMoreCurrentPhaseEvents;
        boolean hasMoreAnyPhaseEvents;
        if (null == this.events) {
            return;
        }
        List<FacesEvent> eventsForPhaseId = this.events.get(PhaseId.ANY_PHASE.getOrdinal());
        do {
            UIComponent compositeParent;
            UIComponent source;
            FacesEvent event;
            if (null != eventsForPhaseId) {
                while (!eventsForPhaseId.isEmpty()) {
                    event = eventsForPhaseId.get(0);
                    source = event.getComponent();
                    compositeParent = null;
                    try {
                        if (!UIComponent.isCompositeComponent(source)) {
                            compositeParent = UIComponent.getCompositeComponentParent(source);
                        }
                        if (compositeParent != null) {
                            compositeParent.pushComponentToEL(context, null);
                        }
                        source.pushComponentToEL(context, null);
                        source.broadcast(event);
                    }
                    catch (AbortProcessingException e) {
                        context.getApplication().publishEvent(context, ExceptionQueuedEvent.class, new ExceptionQueuedEventContext(context, e, source, phaseId));
                    }
                    finally {
                        source.popComponentFromEL(context);
                        if (compositeParent != null) {
                            compositeParent.popComponentFromEL(context);
                        }
                    }
                    eventsForPhaseId.remove(0);
                }
            }
            if (null != (eventsForPhaseId = this.events.get(phaseId.getOrdinal()))) {
                while (!eventsForPhaseId.isEmpty()) {
                    event = eventsForPhaseId.get(0);
                    source = event.getComponent();
                    compositeParent = null;
                    try {
                        if (!UIComponent.isCompositeComponent(source)) {
                            compositeParent = UIViewRoot.getCompositeComponentParent(source);
                        }
                        if (compositeParent != null) {
                            compositeParent.pushComponentToEL(context, null);
                        }
                        source.pushComponentToEL(context, null);
                        source.broadcast(event);
                    }
                    catch (AbortProcessingException ape) {
                        context.getApplication().publishEvent(context, ExceptionQueuedEvent.class, new ExceptionQueuedEventContext(context, ape, source, phaseId));
                    }
                    finally {
                        source.popComponentFromEL(context);
                        if (compositeParent != null) {
                            compositeParent.popComponentFromEL(context);
                        }
                    }
                    eventsForPhaseId.remove(0);
                }
            }
            hasMoreAnyPhaseEvents = null != (eventsForPhaseId = this.events.get(PhaseId.ANY_PHASE.getOrdinal())) && !eventsForPhaseId.isEmpty();
            boolean bl = hasMoreCurrentPhaseEvents = null != this.events.get(phaseId.getOrdinal()) && !this.events.get(phaseId.getOrdinal()).isEmpty();
        } while (hasMoreAnyPhaseEvents || hasMoreCurrentPhaseEvents);
    }

    private void initState() {
        this.skipPhase = false;
        this.beforeMethodException = false;
        List listeners = (List)this.getStateHelper().get((Serializable)((Object)PropertyKeys.phaseListeners));
        this.phaseListenerIterator = listeners != null ? listeners.listIterator() : null;
    }

    private void notifyBefore(FacesContext context, PhaseId phaseId) {
        if (this.getBeforePhaseListener() != null || this.phaseListenerIterator != null) {
            this.notifyPhaseListeners(context, phaseId, true);
        }
    }

    private void notifyAfter(FacesContext context, PhaseId phaseId) {
        if (this.getAfterPhaseListener() != null || this.phaseListenerIterator != null) {
            this.notifyPhaseListeners(context, phaseId, false);
        }
    }

    @Override
    public void processRestoreState(FacesContext context, Object state) {
        if (context.getViewRoot() == null) {
            context.setViewRoot(this);
        }
        super.processRestoreState(context, state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processDecodes(FacesContext context) {
        this.initState();
        this.notifyBefore(context, PhaseId.APPLY_REQUEST_VALUES);
        try {
            if (!this.skipPhase) {
                if (context.getPartialViewContext().isPartialRequest() && !context.getPartialViewContext().isExecuteAll()) {
                    context.getPartialViewContext().processPartial(PhaseId.APPLY_REQUEST_VALUES);
                } else {
                    super.processDecodes(context);
                }
                this.broadcastEvents(context, PhaseId.APPLY_REQUEST_VALUES);
            }
        }
        finally {
            this.clearFacesEvents(context);
            this.notifyAfter(context, PhaseId.APPLY_REQUEST_VALUES);
        }
    }

    @Override
    public void encodeBegin(FacesContext context) throws IOException {
        this.initState();
        this.notifyBefore(context, PhaseId.RENDER_RESPONSE);
        if (!context.getResponseComplete()) {
            super.encodeBegin(context);
        }
    }

    @Override
    public void encodeChildren(FacesContext context) throws IOException {
        if (context.getPartialViewContext().isAjaxRequest()) {
            context.getPartialViewContext().processPartial(PhaseId.RENDER_RESPONSE);
        } else {
            super.encodeChildren(context);
        }
    }

    @Override
    public void encodeEnd(FacesContext context) throws IOException {
        super.encodeEnd(context);
        this.encodeViewParameters(context);
        this.notifyAfter(context, PhaseId.RENDER_RESPONSE);
    }

    @Override
    public boolean getRendersChildren() {
        boolean value = super.getRendersChildren();
        FacesContext context = FacesContext.getCurrentInstance();
        if (context.getPartialViewContext().isAjaxRequest()) {
            value = true;
        }
        return value;
    }

    private void notifyPhaseListeners(FacesContext context, PhaseId phaseId, boolean isBefore) {
        MethodExpression expression;
        PhaseEvent event = UIViewRoot.createPhaseEvent(context, phaseId);
        MethodExpression beforePhase = this.getBeforePhaseListener();
        MethodExpression afterPhase = this.getAfterPhaseListener();
        boolean hasPhaseMethodExpression = isBefore && null != beforePhase || !isBefore && null != afterPhase && !this.beforeMethodException;
        MethodExpression methodExpression = expression = isBefore ? beforePhase : afterPhase;
        if (hasPhaseMethodExpression) {
            try {
                expression.invoke(context.getELContext(), new Object[]{event});
                this.skipPhase = context.getResponseComplete() || context.getRenderResponse();
            }
            catch (Exception e) {
                if (isBefore) {
                    this.beforeMethodException = true;
                }
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, "severe.component.unable_to_process_expression", new Object[]{expression.getExpressionString(), isBefore ? "beforePhase" : "afterPhase"});
                }
                return;
            }
        }
        if (this.phaseListenerIterator != null && !this.beforeMethodException) {
            while (isBefore ? this.phaseListenerIterator.hasNext() : this.phaseListenerIterator.hasPrevious()) {
                PhaseListener curListener;
                PhaseListener phaseListener = curListener = isBefore ? this.phaseListenerIterator.next() : this.phaseListenerIterator.previous();
                if (phaseId != curListener.getPhaseId() && PhaseId.ANY_PHASE != curListener.getPhaseId()) continue;
                try {
                    if (isBefore) {
                        curListener.beforePhase(event);
                    } else {
                        curListener.afterPhase(event);
                    }
                    this.skipPhase = context.getResponseComplete() || context.getRenderResponse();
                }
                catch (Exception e) {
                    if (isBefore && this.phaseListenerIterator.hasPrevious()) {
                        this.phaseListenerIterator.previous();
                    }
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, "severe.component.uiviewroot_error_invoking_phaselistener", curListener.getClass().getName());
                    }
                    return;
                }
            }
        }
    }

    private static PhaseEvent createPhaseEvent(FacesContext context, PhaseId phaseId) throws FacesException {
        if (lifecycle == null) {
            LifecycleFactory lifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory("javax.faces.lifecycle.LifecycleFactory");
            String lifecycleId = context.getExternalContext().getInitParameter("javax.faces.LIFECYCLE_ID");
            if (lifecycleId == null) {
                lifecycleId = "DEFAULT";
            }
            lifecycle = lifecycleFactory.getLifecycle(lifecycleId);
        }
        return new PhaseEvent(context, phaseId, lifecycle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processValidators(FacesContext context) {
        this.initState();
        this.notifyBefore(context, PhaseId.PROCESS_VALIDATIONS);
        try {
            if (!this.skipPhase) {
                if (context.getPartialViewContext().isPartialRequest() && !context.getPartialViewContext().isExecuteAll()) {
                    context.getPartialViewContext().processPartial(PhaseId.PROCESS_VALIDATIONS);
                } else {
                    super.processValidators(context);
                }
                this.broadcastEvents(context, PhaseId.PROCESS_VALIDATIONS);
            }
        }
        finally {
            this.clearFacesEvents(context);
            this.notifyAfter(context, PhaseId.PROCESS_VALIDATIONS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processUpdates(FacesContext context) {
        this.initState();
        this.notifyBefore(context, PhaseId.UPDATE_MODEL_VALUES);
        try {
            if (!this.skipPhase) {
                if (context.getPartialViewContext().isPartialRequest() && !context.getPartialViewContext().isExecuteAll()) {
                    context.getPartialViewContext().processPartial(PhaseId.UPDATE_MODEL_VALUES);
                } else {
                    super.processUpdates(context);
                }
                this.broadcastEvents(context, PhaseId.UPDATE_MODEL_VALUES);
            }
        }
        finally {
            this.clearFacesEvents(context);
            this.notifyAfter(context, PhaseId.UPDATE_MODEL_VALUES);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processApplication(FacesContext context) {
        this.initState();
        this.notifyBefore(context, PhaseId.INVOKE_APPLICATION);
        try {
            if (!this.skipPhase) {
                this.broadcastEvents(context, PhaseId.INVOKE_APPLICATION);
            }
        }
        finally {
            this.clearFacesEvents(context);
            this.notifyAfter(context, PhaseId.INVOKE_APPLICATION);
        }
    }

    private void clearFacesEvents(FacesContext context) {
        if ((context.getRenderResponse() || context.getResponseComplete()) && this.events != null) {
            for (List<FacesEvent> eventList : this.events) {
                if (eventList == null) continue;
                eventList.clear();
            }
            this.events = null;
        }
    }

    public String createUniqueId() {
        return this.createUniqueId(this.getFacesContext(), null);
    }

    @Override
    public String createUniqueId(FacesContext context, String seed) {
        if (seed != null) {
            return UNIQUE_ID_PREFIX + seed;
        }
        Integer i = (Integer)this.getStateHelper().get((Serializable)((Object)PropertyKeys.lastId));
        int lastId = i != null ? i : 0;
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.lastId), ++lastId);
        return UNIQUE_ID_PREFIX + lastId;
    }

    public Locale getLocale() {
        Object result = this.getStateHelper().eval((Serializable)((Object)PropertyKeys.locale));
        if (result != null) {
            Locale locale = null;
            if (result instanceof Locale) {
                locale = (Locale)result;
            } else if (result instanceof String) {
                locale = UIViewRoot.getLocaleFromString((String)result);
            }
            return locale;
        }
        FacesContext context = this.getFacesContext();
        return context.getApplication().getViewHandler().calculateLocale(context);
    }

    private static Locale getLocaleFromString(String localeStr) throws IllegalArgumentException {
        if (null == localeStr || localeStr.length() < 2) {
            throw new IllegalArgumentException("Illegal locale String: " + localeStr);
        }
        Locale result = null;
        String lang = null;
        String country = null;
        String variant = null;
        char[] seps = new char[]{'-', '_'};
        int inputLength = localeStr.length();
        int i = 0;
        int j = 0;
        if (inputLength >= 2 && (i = UIViewRoot.indexOfSet(localeStr, seps, 0)) == -1) {
            if (2 != localeStr.length()) {
                throw new IllegalArgumentException("Illegal locale String: " + localeStr);
            }
            lang = localeStr.toLowerCase();
        }
        if (i != -1) {
            lang = localeStr.substring(0, i);
            if (inputLength >= 5 && -1 == (j = UIViewRoot.indexOfSet(localeStr, seps, i + 1))) {
                if (inputLength != 5) {
                    throw new IllegalArgumentException("Illegal locale String: " + localeStr);
                }
                country = localeStr.substring(i + 1);
            }
            if (j != -1) {
                country = localeStr.substring(i + 1, j);
                if (inputLength >= 8) {
                    variant = localeStr.substring(j + 1);
                } else {
                    throw new IllegalArgumentException("Illegal locale String: " + localeStr);
                }
            }
        }
        if (variant != null && country != null && lang != null) {
            result = new Locale(lang, country, variant);
        } else if (lang != null && country != null) {
            result = new Locale(lang, country);
        } else if (lang != null) {
            result = new Locale(lang, "");
        }
        return result;
    }

    private static int indexOfSet(String str, char[] set, int fromIndex) {
        int result = -1;
        int len = str.length();
        for (int i = fromIndex; i < len; ++i) {
            int innerLen = set.length;
            for (int j = 0; j < innerLen; ++j) {
                if (str.charAt(i) != set[j]) continue;
                result = i;
                break;
            }
            if (-1 != result) break;
        }
        return result;
    }

    public void setLocale(Locale locale) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.locale), locale);
        FacesContext.getCurrentInstance().getELContext().setLocale(locale);
    }

    public Map<String, Object> getViewMap() {
        return this.getViewMap(true);
    }

    public Map<String, Object> getViewMap(boolean create) {
        if (create && this.viewScope == null) {
            this.viewScope = new ViewMap(this.getFacesContext().getApplication().getProjectStage());
            this.getFacesContext().getApplication().publishEvent(this.getFacesContext(), PostConstructViewMapEvent.class, this);
        }
        return this.viewScope;
    }

    public void subscribeToViewEvent(Class<? extends SystemEvent> systemEvent, SystemEventListener listener) {
        List<SystemEventListener> listeners;
        if (systemEvent == null) {
            throw new NullPointerException();
        }
        if (listener == null) {
            throw new NullPointerException();
        }
        if (this.viewListeners == null) {
            this.viewListeners = new HashMap<Class<? extends SystemEvent>, List<SystemEventListener>>(4, 1.0f);
        }
        if ((listeners = this.viewListeners.get(systemEvent)) == null) {
            listeners = new CopyOnWriteArrayList<SystemEventListener>();
            this.viewListeners.put(systemEvent, listeners);
        }
        listeners.add(listener);
    }

    public void unsubscribeFromViewEvent(Class<? extends SystemEvent> systemEvent, SystemEventListener listener) {
        List<SystemEventListener> listeners;
        if (systemEvent == null) {
            throw new NullPointerException();
        }
        if (listener == null) {
            throw new NullPointerException();
        }
        if (this.viewListeners != null && (listeners = this.viewListeners.get(systemEvent)) != null) {
            listeners.remove(listener);
        }
    }

    public List<SystemEventListener> getViewListenersForEventClass(Class<? extends SystemEvent> systemEvent) {
        if (systemEvent == null) {
            throw new NullPointerException();
        }
        if (this.viewListeners != null) {
            return this.viewListeners.get(systemEvent);
        }
        return null;
    }

    private void encodeViewParameters(FacesContext context) {
        ViewDeclarationLanguage vdl = context.getApplication().getViewHandler().getViewDeclarationLanguage(context, this.getViewId());
        if (vdl == null) {
            return;
        }
        ViewMetadata metadata = vdl.getViewMetadata(context, this.getViewId());
        if (metadata != null) {
            Collection<UIViewParameter> params = ViewMetadata.getViewParameters(this);
            if (params.isEmpty()) {
                return;
            }
            try {
                for (UIViewParameter param : params) {
                    param.encodeAll(context);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Unexpected IOException", e);
            }
        }
    }

    @Override
    public Object saveState(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        Object superState = super.saveState(context);
        Object attachedState = UIViewRoot.saveAttachedState(context, this.viewScope);
        if (superState != null || attachedState != null) {
            this.values = new Object[]{superState, attachedState};
        }
        return this.values;
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (state == null) {
            return;
        }
        this.values = (Object[])state;
        super.restoreState(context, this.values[0]);
        this.viewScope = (Map)UIViewRoot.restoreAttachedState(context, this.values[1]);
    }

    private static String getIdentifier(String target) {
        String id = LOCATION_IDENTIFIER_MAP.get(target);
        if (id == null) {
            id = LOCATION_IDENTIFIER_PREFIX + target;
            LOCATION_IDENTIFIER_MAP.put(target, id);
        }
        return id;
    }

    private List<UIComponent> getComponentResources(FacesContext context, String target, boolean create) {
        String location = UIViewRoot.getIdentifier(target);
        UIComponent facet = this.getFacet(location);
        if (facet == null && create) {
            facet = context.getApplication().createComponent("javax.faces.ComponentResourceContainer");
            facet.setId(location);
            this.getFacets().put(location, facet);
        }
        return facet != null ? facet.getChildren() : null;
    }

    static {
        LOGGER = Logger.getLogger("javax.faces", "javax.faces.LogStrings");
        LOCATION_IDENTIFIER_MAP = new HashMap<String, String>(6, 1.0f);
        LOCATION_IDENTIFIER_MAP.put("head", "javax_faces_location_HEAD");
        LOCATION_IDENTIFIER_MAP.put("form", "javax_faces_location_FORM");
        LOCATION_IDENTIFIER_MAP.put("body", "javax_faces_location_BODY");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum PropertyKeys {
        renderKitId,
        viewId,
        locale,
        lastId,
        beforePhase,
        afterPhase,
        phaseListeners,
        viewScope;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ViewMap
    extends HashMap<String, Object> {
        private static final long serialVersionUID = -1L;
        private ProjectStage stage;

        ViewMap(ProjectStage stage) {
            this.stage = stage;
        }

        @Override
        public void clear() {
            FacesContext context = FacesContext.getCurrentInstance();
            context.getApplication().publishEvent(context, PreDestroyViewMapEvent.class, context.getViewRoot());
            super.clear();
        }

        @Override
        public Object put(String key, Object value) {
            if (value != null && ProjectStage.Development.equals((Object)this.stage) && !(value instanceof Serializable)) {
                LOGGER.log(Level.WARNING, "warning.component.uiviewroot_non_serializable_attribute_viewmap", new Object[]{key, value.getClass().getName()});
            }
            return super.put(key, value);
        }

        @Override
        public void putAll(Map<? extends String, ?> m) {
            for (Map.Entry<String, ?> entry : m.entrySet()) {
                String k = entry.getKey();
                Object v = entry.getValue();
                this.put(k, v);
            }
        }
    }
}

