/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config.rules;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.config.rules.ValidationBase;
import org.apache.xbean.finder.ResourceFinder;

public class CheckDescriptorLocation
extends ValidationBase {
    EjbModule currentModule;

    @Override
    public void validate(EjbModule ejbModule) {
        Object baseUrl = null;
        this.currentModule = ejbModule;
        File file = ejbModule.getFile();
        if (file != null) {
            this.validateDescriptorsAreNotPlacedInRoot(file);
        }
    }

    private void validateDescriptorsAreNotPlacedInRoot(File file) {
        ResourceFinder resourceFinder = null;
        try {
            resourceFinder = new ResourceFinder(new URL[]{file.toURI().toURL()});
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        Map<String, URL> descriptorsPlacedInWrongLocation = CheckDescriptorLocation.getDescriptorsPlacedInWrongLocation(resourceFinder);
        if (descriptorsPlacedInWrongLocation.size() > 0) {
            this.warnIncorrectLocationOfDescriptors(descriptorsPlacedInWrongLocation);
        }
    }

    private static Map<String, URL> getDescriptorsPlacedInWrongLocation(ResourceFinder finder) {
        Map<String, URL> descriptorsMap = null;
        try {
            descriptorsMap = CheckDescriptorLocation.retrieveDescriptorsPlacedInWrongLocation(finder);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return descriptorsMap;
    }

    private static Map<String, URL> retrieveDescriptorsPlacedInWrongLocation(ResourceFinder finder) throws IOException {
        String[] known;
        HashMap<String, URL> map = new HashMap<String, URL>();
        for (String descriptor : known = new String[]{"web.xml", "ejb-jar.xml", "openejb-jar.xml", "env-entries.properties", "beans.xml", "ra.xml", "application.xml", "application-client.xml", "persistence.xml"}) {
            URL url = finder.getResource(descriptor);
            if (url == null) continue;
            map.put(descriptor, url);
        }
        return map;
    }

    private void warnIncorrectLocationOfDescriptors(Map<String, URL> descriptorsPlacedInWrongLocation) {
        for (Map.Entry<String, URL> map : descriptorsPlacedInWrongLocation.entrySet()) {
            this.warn(this.currentModule.toString(), "descriptor.incorrectLocation", map.getKey(), map.getValue());
        }
    }
}

