/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.util.Messages;

public class JarUtils {
    private static Messages messages = new Messages("org.apache.openejb.util.resources");

    public static void addFileToJar(String jarFile, String file) throws OpenEJBException {
        try {
            JarInputStream jis = new JarInputStream(new FileInputStream(jarFile));
            File tempJar = File.createTempFile("temp", "jar");
            JarOutputStream jos = new JarOutputStream(new FileOutputStream(tempJar));
            JarEntry nextJarEntry = null;
            while ((nextJarEntry = jis.getNextJarEntry()) != null) {
                jos.putNextEntry(nextJarEntry);
            }
            jis.close();
            jos.putNextEntry(new JarEntry(file));
            FileInputStream fis = new FileInputStream(file);
            int c = fis.read();
            while (c != -1) {
                jos.write(c);
                c = fis.read();
            }
            fis.close();
            jos.close();
            File oldJar = new File(jarFile);
            oldJar.delete();
            tempJar.renameTo(oldJar);
        }
        catch (FileNotFoundException e) {
            throw new OpenEJBException(messages.format("file.0003", file, jarFile, e.getMessage()), e);
        }
        catch (IOException e) {
            throw new OpenEJBException(messages.format("file.0003", file, jarFile, e.getMessage()), e);
        }
    }

    public static JarFile getJarFile(String jarFile) throws OpenEJBException {
        JarFile jar = null;
        try {
            File file = new File(jarFile);
            jar = new JarFile(file);
        }
        catch (FileNotFoundException e) {
            throw new OpenEJBException(messages.format("file.0001", jarFile, e.getLocalizedMessage()), e);
        }
        catch (IOException e) {
            throw new OpenEJBException(messages.format("file.0002", jarFile, e.getLocalizedMessage()), e);
        }
        return jar;
    }

    public static ClassLoader getContextClassLoader() {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }
}

