/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.SimpleLayout;
import org.apache.openejb.loader.FileUtils;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.ConfUtils;
import org.apache.openejb.util.Log4jLogStream;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.LogStream;
import org.apache.openejb.util.LogStreamFactory;

public class Log4jLogStreamFactory
implements LogStreamFactory {
    private static final String LOGGING_PROPERTIES_FILE = "logging.properties";
    private static final String EMBEDDED_PROPERTIES_FILE = "embedded.logging.properties";

    @Override
    public LogStream createLogStream(LogCategory logCategory) {
        return new Log4jLogStream(logCategory);
    }

    public Log4jLogStreamFactory() {
        try {
            String prop = System.getProperty("openejb.logger.external", "false");
            boolean externalLogging = Boolean.parseBoolean(prop);
            if (!externalLogging) {
                this.configureInternal();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void configureInternal() throws IOException {
        System.setProperty("openjpa.Log", "log4j");
        boolean embedded = System.getProperty("openejb.logging.embedded", "false").equalsIgnoreCase("true");
        File confDir = SystemInstance.get().getBase().getDirectory("conf");
        File loggingPropertiesFile = new File(confDir, LOGGING_PROPERTIES_FILE);
        if (!embedded && confDir.exists()) {
            if (loggingPropertiesFile.exists()) {
                BufferedInputStream bis = new BufferedInputStream(new FileInputStream(loggingPropertiesFile));
                Properties props = new Properties();
                props.load(bis);
                Log4jLogStreamFactory.applyOverrides(props);
                this.preprocessProperties(props);
                PropertyConfigurator.configure((Properties)props);
                try {
                    bis.close();
                }
                catch (IOException e) {}
            } else {
                this.installLoggingPropertiesFile(loggingPropertiesFile);
            }
        } else {
            this.configureEmbedded();
        }
    }

    private static void applyOverrides(Properties properties) {
        Properties system = SystemInstance.get().getProperties();
        for (Map.Entry<Object, Object> entry : system.entrySet()) {
            String key = entry.getKey().toString();
            if (!key.startsWith("log4j.") || key.equals("log4j.configuration")) continue;
            properties.put(key, entry.getValue());
        }
    }

    private void preprocessProperties(Properties properties) {
        FileUtils base = SystemInstance.get().getBase();
        File confDir = new File(base.getDirectory(), "conf");
        File baseDir = base.getDirectory();
        File userDir = new File("foo").getParentFile();
        File[] paths = new File[]{confDir, baseDir, userDir};
        ArrayList<File> missing = new ArrayList<File>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (!key.endsWith(".File")) continue;
            boolean found = false;
            for (int i = 0; i < paths.length && !found; ++i) {
                File path = paths[i];
                File logfile = new File(path, value);
                if (!logfile.getParentFile().exists()) continue;
                properties.setProperty(key, logfile.getAbsolutePath());
                found = true;
            }
            if (found) continue;
            File logfile = new File(paths[0], value);
            missing.add(logfile);
        }
        if (missing.size() > 0) {
            org.apache.log4j.Logger logger = this.getFallabckLogger();
            logger.error((Object)"Logging may not operate as expected.  The directories for the following files do not exist so no file can be created.  See the list below.");
            for (int i = 0; i < missing.size(); ++i) {
                File file = (File)missing.get(i);
                logger.error((Object)("[" + i + "] " + file.getAbsolutePath()));
            }
        }
    }

    private org.apache.log4j.Logger getFallabckLogger() {
        org.apache.log4j.Logger logger = org.apache.log4j.Logger.getLogger((String)"OpenEJB.logging");
        SimpleLayout simpleLayout = new SimpleLayout();
        ConsoleAppender newAppender = new ConsoleAppender((Layout)simpleLayout);
        logger.addAppender((Appender)newAppender);
        return logger;
    }

    private void configureEmbedded() {
        URL resource = ConfUtils.getResource(EMBEDDED_PROPERTIES_FILE);
        if (resource == null) {
            System.err.println("FATAL ERROR WHILE CONFIGURING LOGGING!!!. MISSING embedded.logging.properties FILE ");
        } else {
            Properties properties = Log4jLogStreamFactory.asProperies(resource);
            Log4jLogStreamFactory.applyOverrides(properties);
            PropertyConfigurator.configure((Properties)properties);
            Logger logger = Logger.getLogger("org.apache");
            Logger parent = logger.getParent();
            parent.setLevel(Level.WARNING);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties asProperies(URL resource) {
        Properties properties = new Properties();
        InputStream in = null;
        try {
            in = resource.openStream();
            in = new BufferedInputStream(in);
            properties.load(in);
        }
        catch (IOException e) {
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {}
        }
        return properties;
    }

    private void installLoggingPropertiesFile(File loggingPropertiesFile) throws IOException {
        URL resource = Thread.currentThread().getContextClassLoader().getResource(LOGGING_PROPERTIES_FILE);
        if (resource == null) {
            System.err.println("FATAL ERROR WHILE CONFIGURING LOGGING!!!. MISSING logging.properties FILE ");
            return;
        }
        InputStream in = resource.openStream();
        in = new BufferedInputStream(in);
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        byte[] buf = new byte[4096];
        int count = in.read(buf);
        while (count >= 0) {
            bao.write(buf, 0, count);
            count = in.read(buf);
        }
        byte[] byteArray = bao.toByteArray();
        ByteArrayInputStream bis = new ByteArrayInputStream(byteArray);
        Properties props = new Properties();
        props.load(bis);
        this.preprocessProperties(props);
        BufferedOutputStream bout = new BufferedOutputStream(new FileOutputStream(loggingPropertiesFile));
        bout.write(byteArray);
        PropertyConfigurator.configure((Properties)props);
        try {
            bout.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            in.close();
        }
        catch (IOException e) {
            // empty catch block
        }
    }
}

