/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.tag;

import com.sun.faces.facelets.compiler.CompilationMessageHolder;
import com.sun.faces.facelets.tag.TagLibrary;
import com.sun.faces.facelets.tag.jsf.CompositeComponentTagLibrary;
import com.sun.faces.util.Util;
import java.lang.reflect.Method;
import java.util.List;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.application.ProjectStage;
import javax.faces.context.FacesContext;
import javax.faces.view.facelets.Tag;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagHandler;

public final class CompositeTagLibrary
implements TagLibrary {
    private TagLibrary[] libraries;
    private CompilationMessageHolder messageHolder;

    public CompositeTagLibrary(TagLibrary[] libraries, CompilationMessageHolder unit) {
        Util.notNull("libraries", libraries);
        this.libraries = libraries;
        this.messageHolder = unit;
    }

    public CompositeTagLibrary(TagLibrary[] libraries) {
        this(libraries, null);
    }

    public boolean containsNamespace(String ns, Tag t) {
        boolean result = true;
        for (int i = 0; i < this.libraries.length; ++i) {
            if (!this.libraries[i].containsNamespace(ns, null)) continue;
            return true;
        }
        CompositeComponentTagLibrary toTest = new CompositeComponentTagLibrary(ns);
        if (toTest.tagLibraryForNSExists(ns)) {
            TagLibrary[] librariesPlusOne = new TagLibrary[this.libraries.length + 1];
            System.arraycopy(this.libraries, 0, librariesPlusOne, 0, this.libraries.length);
            librariesPlusOne[this.libraries.length] = new CompositeComponentTagLibrary(ns);
            for (int i = 0; i < this.libraries.length; ++i) {
                this.libraries[i] = null;
            }
            this.libraries = librariesPlusOne;
            return true;
        }
        FacesContext context = FacesContext.getCurrentInstance();
        if (context.isProjectStage(ProjectStage.Development) && null != t && !ns.equals("http://www.w3.org/1999/xhtml")) {
            assert (null != this.messageHolder);
            String prefix = this.getPrefixFromTag(t);
            if (null != prefix) {
                List<FacesMessage> prefixMessages = this.messageHolder.getNamespacePrefixMessages(context, prefix);
                prefixMessages.add(new FacesMessage(FacesMessage.SEVERITY_WARN, "Warning: This page calls for XML namespace " + ns + " declared with prefix " + prefix + " but no taglibrary exists for that namespace.", ""));
            }
        }
        return false;
    }

    private String getPrefixFromTag(Tag t) {
        int i;
        String result = t.getQName();
        if (null != result && -1 != (i = result.indexOf(":"))) {
            result = result.substring(0, i);
        }
        return result;
    }

    public boolean containsTagHandler(String ns, String localName) {
        for (int i = 0; i < this.libraries.length; ++i) {
            if (!this.libraries[i].containsTagHandler(ns, localName)) continue;
            return true;
        }
        return false;
    }

    public TagHandler createTagHandler(String ns, String localName, TagConfig tag) throws FacesException {
        for (int i = 0; i < this.libraries.length; ++i) {
            if (!this.libraries[i].containsTagHandler(ns, localName)) continue;
            return this.libraries[i].createTagHandler(ns, localName, tag);
        }
        return null;
    }

    public boolean containsFunction(String ns, String name) {
        for (int i = 0; i < this.libraries.length; ++i) {
            if (!this.libraries[i].containsFunction(ns, name)) continue;
            return true;
        }
        return false;
    }

    public Method createFunction(String ns, String name) {
        for (int i = 0; i < this.libraries.length; ++i) {
            if (!this.libraries[i].containsFunction(ns, name)) continue;
            return this.libraries[i].createFunction(ns, name);
        }
        return null;
    }
}

