/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.tag.jsf.core;

import com.sun.faces.facelets.tag.TagHandlerImpl;
import com.sun.faces.facelets.tag.jsf.CompositeComponentTagHandler;
import com.sun.faces.facelets.util.ReflectionUtil;
import java.io.IOException;
import java.io.Serializable;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.component.ActionSource;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import javax.faces.view.ActionSource2AttachedObjectHandler;
import javax.faces.view.AttachedObjectHandler;
import javax.faces.view.facelets.ComponentHandler;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagAttributeException;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagException;

public final class ActionListenerHandler
extends TagHandlerImpl
implements ActionSource2AttachedObjectHandler {
    private final TagAttribute binding = this.getAttribute("binding");
    private String listenerType;
    private final TagAttribute typeAttribute = this.getAttribute("type");

    public ActionListenerHandler(TagConfig config) {
        super(config);
        if (null != this.typeAttribute) {
            String stringType = null;
            if (!this.typeAttribute.isLiteral()) {
                FacesContext context = FacesContext.getCurrentInstance();
                FaceletContext ctx = (FaceletContext)context.getAttributes().get("com.sun.faces.facelets.FACELET_CONTEXT");
                stringType = (String)this.typeAttribute.getValueExpression(ctx, String.class).getValue((ELContext)ctx);
            } else {
                stringType = this.typeAttribute.getValue();
            }
            this.checkType(stringType);
            this.listenerType = stringType;
        } else {
            this.listenerType = null;
        }
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException {
        if (null == parent || !ComponentHandler.isNew((UIComponent)parent)) {
            return;
        }
        if (parent instanceof ActionSource) {
            this.applyAttachedObject(ctx.getFacesContext(), parent);
        } else if (parent.getAttributes().containsKey("javax.faces.application.Resource.ComponentResource")) {
            if (null == this.getFor()) {
                throw new TagException(this.tag, "actionListener tags nested within composite components must have a non-null \"for\" attribute");
            }
            CompositeComponentTagHandler.getAttachedObjectHandlers(parent).add((AttachedObjectHandler)this);
        } else {
            throw new TagException(this.tag, "Parent is not of type ActionSource, type is: " + parent);
        }
    }

    public void applyAttachedObject(FacesContext context, UIComponent parent) {
        FaceletContext ctx = (FaceletContext)context.getAttributes().get("com.sun.faces.facelets.FACELET_CONTEXT");
        ActionSource as = (ActionSource)parent;
        ValueExpression b = null;
        if (this.binding != null) {
            b = this.binding.getValueExpression(ctx, ActionListener.class);
        }
        LazyActionListener listener = new LazyActionListener(this.listenerType, b);
        as.addActionListener((ActionListener)listener);
    }

    public String getFor() {
        String result = null;
        TagAttribute attr = this.getAttribute("for");
        if (null != attr) {
            if (attr.isLiteral()) {
                result = attr.getValue();
            } else {
                FacesContext context = FacesContext.getCurrentInstance();
                FaceletContext ctx = (FaceletContext)context.getAttributes().get("com.sun.faces.facelets.FACELET_CONTEXT");
                result = (String)attr.getValueExpression(ctx, String.class).getValue((ELContext)ctx);
            }
        }
        return result;
    }

    private void checkType(String type) {
        try {
            ReflectionUtil.forName(type);
        }
        catch (ClassNotFoundException e) {
            throw new TagAttributeException(this.typeAttribute, "Couldn't qualify ActionListener", (Throwable)e);
        }
    }

    private static final class LazyActionListener
    implements ActionListener,
    Serializable {
        private static final long serialVersionUID = -9202120013153262119L;
        private final String type;
        private final ValueExpression binding;

        public LazyActionListener(String type, ValueExpression binding) {
            this.type = type;
            this.binding = binding;
        }

        public void processAction(ActionEvent event) throws AbortProcessingException {
            ActionListener instance = null;
            FacesContext faces = FacesContext.getCurrentInstance();
            if (faces == null) {
                return;
            }
            if (this.binding != null) {
                instance = (ActionListener)this.binding.getValue(faces.getELContext());
            }
            if (instance == null && this.type != null) {
                try {
                    instance = (ActionListener)ReflectionUtil.forName(this.type).newInstance();
                }
                catch (Exception e) {
                    throw new AbortProcessingException("Couldn't Lazily instantiate ValueChangeListener", (Throwable)e);
                }
                if (this.binding != null) {
                    this.binding.setValue(faces.getELContext(), (Object)instance);
                }
            }
            if (instance != null) {
                instance.processAction(event);
            }
        }
    }
}

