/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.net;

import java.util.Hashtable;
import javax.transaction.xa.Xid;
import org.apache.derby.client.ClientXid;
import org.apache.derby.client.am.ConnectionCallbackInterface;
import org.apache.derby.client.am.DisconnectException;
import org.apache.derby.client.net.CodePoint;
import org.apache.derby.client.net.NetAgent;
import org.apache.derby.client.net.NetConnection;
import org.apache.derby.client.net.NetIndoubtTransaction;
import org.apache.derby.client.net.NetResultSetReply;
import org.apache.derby.client.net.NetXACallInfo;

public class NetXAConnectionReply
extends NetResultSetReply {
    NetXAConnectionReply(NetAgent netAgent, int n) {
        super(netAgent, n);
    }

    public void readLocalXAStart(ConnectionCallbackInterface connectionCallbackInterface) throws DisconnectException {
    }

    public void readLocalXACommit(ConnectionCallbackInterface connectionCallbackInterface) throws DisconnectException {
        this.startSameIdChainParse();
        this.parseSYNCCTLreply(connectionCallbackInterface);
        this.endOfSameIdChainData();
        NetXACallInfo netXACallInfo = this.netAgent_.netConnection_.xares_.callInfoArray_[this.netAgent_.netConnection_.currXACallInfoOffset_];
        netXACallInfo.xaInProgress_ = false;
        netXACallInfo.xaWasSuspended = false;
        connectionCallbackInterface.completeLocalCommit();
    }

    public void readLocalXARollback(ConnectionCallbackInterface connectionCallbackInterface) throws DisconnectException {
        this.startSameIdChainParse();
        this.parseSYNCCTLreply(connectionCallbackInterface);
        this.endOfSameIdChainData();
        connectionCallbackInterface.completeLocalRollback();
    }

    protected void readXaStartUnitOfWork(NetConnection netConnection) throws DisconnectException {
        this.startSameIdChainParse();
        this.parseSYNCCTLreply(netConnection);
        NetXACallInfo netXACallInfo = netConnection.xares_.callInfoArray_[netConnection.currXACallInfoOffset_];
        boolean bl = netXACallInfo.xaFlags_ == 0x200000 || netXACallInfo.xaFlags_ == 0x8000000;
        netConnection.xares_.setKeepCurrentIsolationLevel(bl);
        this.endOfSameIdChainData();
    }

    protected int readXaEndUnitOfWork(NetConnection netConnection) throws DisconnectException {
        netConnection.xares_.setKeepCurrentIsolationLevel(false);
        NetXACallInfo netXACallInfo = netConnection.xares_.callInfoArray_[netConnection.currXACallInfoOffset_];
        int n = netXACallInfo.xaFlags_;
        this.startSameIdChainParse();
        this.parseSYNCCTLreply(netConnection);
        this.endOfSameIdChainData();
        if (n == 0x20000000) {
            return 100;
        }
        return 0;
    }

    protected int readXaPrepare(NetConnection netConnection) throws DisconnectException {
        this.startSameIdChainParse();
        int n = this.parseSYNCCTLreply(netConnection);
        this.endOfSameIdChainData();
        NetXACallInfo netXACallInfo = netConnection.xares_.callInfoArray_[netConnection.currXACallInfoOffset_];
        if (n == 3) {
            netXACallInfo.setReadOnlyTransactionFlag(true);
        } else {
            netXACallInfo.setReadOnlyTransactionFlag(false);
        }
        return n;
    }

    protected void readXaCommit(NetConnection netConnection) throws DisconnectException {
        this.startSameIdChainParse();
        this.parseSYNCCTLreply(netConnection);
        this.endOfSameIdChainData();
        NetXACallInfo netXACallInfo = netConnection.xares_.callInfoArray_[netConnection.currXACallInfoOffset_];
        netXACallInfo.xaInProgress_ = false;
        netConnection.completeLocalCommit();
    }

    protected int readXaRollback(NetConnection netConnection) throws DisconnectException {
        this.startSameIdChainParse();
        this.parseSYNCCTLreply(netConnection);
        this.endOfSameIdChainData();
        NetXACallInfo netXACallInfo = netConnection.xares_.callInfoArray_[netConnection.currXACallInfoOffset_];
        netXACallInfo.xaInProgress_ = false;
        netXACallInfo.xaWasSuspended = false;
        netConnection.completeLocalRollback();
        return 0;
    }

    protected void readXaRecover(NetConnection netConnection) throws DisconnectException {
        this.startSameIdChainParse();
        this.parseSYNCCTLreply(netConnection);
        this.endOfSameIdChainData();
    }

    protected void readXaForget(NetConnection netConnection) throws DisconnectException {
        this.startSameIdChainParse();
        this.parseSYNCCTLreply(netConnection);
        this.endOfSameIdChainData();
    }

    int parseSYNCCRD(ConnectionCallbackInterface connectionCallbackInterface) throws DisconnectException {
        boolean bl = false;
        int n = CodePoint.SVRCOD_INFO;
        int n2 = 0;
        byte by = 0;
        Hashtable hashtable = null;
        NetConnection netConnection = this.netAgent_.netConnection_;
        this.parseLengthAndMatchCodePoint(4680);
        this.pushLengthOnCollectionStack();
        int n3 = this.peekCodePoint();
        while (n3 != -1) {
            boolean bl2 = false;
            if (n3 == 4425) {
                bl2 = true;
                bl = this.checkAndGetReceivedFlag(bl);
                n = this.parseSVRCOD(CodePoint.SVRCOD_ERROR, CodePoint.SVRCOD_ERROR);
                n3 = this.peekCodePoint();
            }
            if (n3 == 6404) {
                bl2 = true;
                netConnection.xares_.callInfoArray_[netConnection.currXACallInfoOffset_].xaRetVal_ = n2 = this.parseXARETVAL();
                n3 = this.peekCodePoint();
            }
            if (n3 == 4487) {
                bl2 = true;
                by = this.parseSYNCTYPE();
                n3 = this.peekCodePoint();
            }
            if (n3 == 6405) {
                bl2 = true;
                hashtable = this.parseIndoubtList();
                netConnection.setIndoubtTransactions(hashtable);
                n3 = this.peekCodePoint();
            }
            if (bl2) continue;
            this.doPrmnsprmSemantics(n3);
        }
        this.popCollectionStack();
        return n2;
    }

    protected int parseXARETVAL() throws DisconnectException {
        this.parseLengthAndMatchCodePoint(6404);
        return this.readInt();
    }

    protected byte parseSYNCTYPE() throws DisconnectException {
        this.parseLengthAndMatchCodePoint(4487);
        return this.readByte();
    }

    protected int parseSYNCCTLreply(ConnectionCallbackInterface connectionCallbackInterface) throws DisconnectException {
        int n = 0;
        int n2 = this.peekCodePoint();
        if (n2 != 4680) {
            this.parseSYNCCTLError(n2);
            return -1;
        }
        n = this.parseSYNCCRD(connectionCallbackInterface);
        n2 = this.peekCodePoint();
        while (n2 == 9236) {
            String string = this.parseSQLSTT();
            this.netAgent_.netConnection_.xares_.addSpecialRegisters(string);
            n2 = this.peekCodePoint();
        }
        if (n2 == 49152) {
            this.parsePBSD();
        }
        return n;
    }

    private String parseSQLSTT() throws DisconnectException {
        this.parseLengthAndMatchCodePoint(9236);
        return this.parseSQLSTTGRPNOCMorNOCS();
    }

    private String parseSQLSTTGRPNOCMorNOCS() throws DisconnectException {
        int n = this.readUnsignedByte();
        int n2 = 0;
        String string = null;
        int n3 = 0;
        if (n == 255) {
            n2 = this.readUnsignedByte();
            if (n2 == 255) {
                this.doDtamchrmSemantics();
            }
            n3 = this.readInt();
            string = this.readString(n3, this.netAgent_.targetTypdef_.getCcsidSbcEncoding());
        } else {
            n3 = this.readInt();
            string = this.readString(n3, this.netAgent_.targetTypdef_.getCcsidMbcEncoding());
            n2 = this.readUnsignedByte();
        }
        return string;
    }

    protected int parseXIDCNT() throws DisconnectException {
        this.parseLengthAndMatchCodePoint(6406);
        return this.readUnsignedShort();
    }

    protected Xid parseXID() throws DisconnectException {
        this.parseLengthAndMatchCodePoint(6145);
        int n = this.readInt();
        int n2 = this.readInt();
        int n3 = this.readInt();
        byte[] byArray = this.readBytes(n2);
        byte[] byArray2 = this.readBytes(n3);
        return new ClientXid(n, byArray, byArray2);
    }

    protected Hashtable parseIndoubtList() throws DisconnectException {
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        String string = null;
        int n3 = this.peekCodePoint();
        this.parseLengthAndMatchCodePoint(6405);
        n3 = this.peekCodePoint();
        if (n3 == 6406) {
            bl = true;
            n2 = this.parseXIDCNT();
            n3 = this.peekCodePoint();
        }
        Hashtable<Xid, NetIndoubtTransaction> hashtable = new Hashtable<Xid, NetIndoubtTransaction>();
        while (n3 == 6145) {
            Xid xid = this.parseXID();
            hashtable.put(xid, new NetIndoubtTransaction(xid, null, null, null, string, n));
            n3 = this.peekCodePoint();
        }
        return hashtable;
    }
}

