/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.model.query;

import java.io.IOException;
import java.util.List;
import org.eclipse.persistence.jpa.jpql.model.query.AbstractStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.StateObject;
import org.eclipse.persistence.jpa.jpql.model.query.StateObjectVisitor;
import org.eclipse.persistence.jpa.jpql.parser.CollectionExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CollectionExpressionStateObject
extends AbstractStateObject {
    private List<? extends StateObject> items;

    public CollectionExpressionStateObject(StateObject parent, List<? extends StateObject> items) {
        super(parent);
        this.items = items;
    }

    @Override
    public void accept(StateObjectVisitor visitor) {
        this.acceptUnknownVisitor(visitor);
    }

    @Override
    protected void addChildren(List<StateObject> children) {
        children.addAll(this.items);
    }

    protected boolean areChildrenEquivalent(CollectionExpressionStateObject stateObject) {
        int size = this.items.size();
        if (size != stateObject.items.size()) {
            return false;
        }
        int index = size;
        while (--index >= 0) {
            StateObject child2;
            StateObject child1 = this.items.get(index);
            if (child1.isEquivalent(child2 = stateObject.items.get(index))) continue;
            return false;
        }
        return true;
    }

    @Override
    public CollectionExpression getExpression() {
        return (CollectionExpression)super.getExpression();
    }

    @Override
    public boolean isEquivalent(StateObject stateObject) {
        if (super.isEquivalent(stateObject)) {
            CollectionExpressionStateObject collection = (CollectionExpressionStateObject)stateObject;
            return this.areChildrenEquivalent(collection);
        }
        return false;
    }

    public void setExpression(CollectionExpression expression) {
        super.setExpression(expression);
    }

    @Override
    protected void toTextInternal(Appendable writer) throws IOException {
        this.toStringItems(writer, this.items, true);
    }
}

