/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.spi.java;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.jpa.jpql.TypeHelper;
import org.eclipse.persistence.jpa.jpql.spi.IType;
import org.eclipse.persistence.jpa.jpql.spi.ITypeRepository;
import org.eclipse.persistence.jpa.jpql.spi.java.JavaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaTypeRepository
implements ITypeRepository {
    private final ClassLoader classLoader;
    private TypeHelper typeHelper;
    private final Map<String, JavaType> types;
    private JavaType unresolvableType;

    public JavaTypeRepository(ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.types = new HashMap<String, JavaType>();
    }

    protected Class<?> attemptLoadType(String typeName) {
        if (typeName.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (typeName.equals("byte")) {
            return Byte.TYPE;
        }
        if (typeName.equals("char")) {
            return Character.TYPE;
        }
        if (typeName.equals("double")) {
            return Double.TYPE;
        }
        if (typeName.equals("float")) {
            return Float.TYPE;
        }
        if (typeName.equals("int")) {
            return Integer.TYPE;
        }
        if (typeName.equals("long")) {
            return Long.TYPE;
        }
        if (typeName.equals("short")) {
            return Short.TYPE;
        }
        try {
            return this.classLoader.loadClass(typeName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    protected JavaType buildType(Class<?> javaType) {
        JavaType type = new JavaType((ITypeRepository)this, javaType);
        this.types.put(javaType.getName(), type);
        return type;
    }

    protected JavaType buildType(String typeName) {
        return new JavaType((ITypeRepository)this, typeName);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public IType getEnumType(String enumTypeName) {
        int lastDotIndex = enumTypeName.lastIndexOf(".");
        if (lastDotIndex == -1) {
            return null;
        }
        String typeName = enumTypeName.substring(0, lastDotIndex);
        JavaType type = this.loadTypeImp(typeName);
        return type.isEnum() ? type : null;
    }

    @Override
    public JavaType getType(Class<?> javaClass) {
        return this.getType(javaClass.getName());
    }

    @Override
    public JavaType getType(String typeName) {
        if (typeName == "UNRESOLVABLE_TYPE") {
            return this.unresolvableType();
        }
        if (typeName.charAt(0) == '[') {
            return this.loadArrayType(typeName);
        }
        return this.loadTypeImp(typeName);
    }

    @Override
    public TypeHelper getTypeHelper() {
        if (this.typeHelper == null) {
            this.typeHelper = new TypeHelper(this);
        }
        return this.typeHelper;
    }

    protected JavaType loadArrayType(String typeName) {
        JavaType type = this.types.get(typeName);
        if (type == null) {
            try {
                type = new JavaType((ITypeRepository)this, Class.forName(typeName));
            }
            catch (ClassNotFoundException classNotFoundException) {
                type = new JavaType((ITypeRepository)this, typeName);
            }
            this.types.put(typeName, type);
        }
        return type;
    }

    protected JavaType loadInnerType(String typeName) {
        int index = typeName.lastIndexOf(".");
        if (index == -1) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(typeName.substring(0, index));
        sb.append("$");
        sb.append(typeName.substring(index + 1, typeName.length()));
        typeName = sb.toString();
        return this.loadTypeImp(typeName);
    }

    protected JavaType loadTypeImp(String typeName) {
        JavaType type = this.types.get(typeName);
        if (type != null) {
            return type;
        }
        Class<?> javaType = this.attemptLoadType(typeName);
        if (javaType != null) {
            return this.buildType(javaType);
        }
        type = this.loadInnerType(typeName);
        if (type == null) {
            type = this.buildType(typeName);
        }
        return type;
    }

    protected JavaType unresolvableType() {
        if (this.unresolvableType == null) {
            this.unresolvableType = new JavaType((ITypeRepository)this, "UNRESOLVABLE_TYPE");
        }
        return this.unresolvableType;
    }
}

