/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.security;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.Permission;
import java.security.Policy;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import javax.security.jacc.EJBMethodPermission;
import javax.security.jacc.PolicyConfigurationFactory;
import javax.security.jacc.PolicyContext;
import org.apache.openejb.BeanContext;
import org.apache.openejb.InterfaceType;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.core.ThreadContextListener;
import org.apache.openejb.core.security.JaccProvider;
import org.apache.openejb.core.security.jaas.GroupPrincipal;
import org.apache.openejb.core.security.jacc.BasicJaccProvider;
import org.apache.openejb.core.security.jacc.BasicPolicyConfiguration;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.spi.CallerPrincipal;
import org.apache.openejb.spi.SecurityService;

public abstract class AbstractSecurityService
implements SecurityService<UUID>,
ThreadContextListener,
BasicPolicyConfiguration.RoleResolver {
    private static final Map<Object, Identity> identities = new ConcurrentHashMap<Object, Identity>();
    protected static final ThreadLocal<Identity> clientIdentity = new ThreadLocal();
    protected String defaultUser = "guest";
    private String realmName = "PropertiesLogin";
    protected Subject defaultSubject;
    protected SecurityContext defaultContext;

    public AbstractSecurityService() {
        this(BasicJaccProvider.class.getName());
    }

    public AbstractSecurityService(String jaccProvider) {
        System.setProperty(JaccProvider.class.getName(), jaccProvider);
        AbstractSecurityService.installJacc();
        ThreadContext.addThreadContextListener(this);
        this.updateSecurityContext();
        SystemInstance.get().setComponent(BasicPolicyConfiguration.RoleResolver.class, (Object)this);
    }

    public String getRealmName() {
        return this.realmName;
    }

    public void setRealmName(String realmName) {
        this.realmName = realmName;
    }

    public String getDefaultUser() {
        return this.defaultUser;
    }

    public void setDefaultUser(String defaultUser) {
        this.defaultUser = defaultUser;
        this.updateSecurityContext();
    }

    private void updateSecurityContext() {
        this.defaultSubject = this.createSubject(this.defaultUser);
        this.defaultContext = new SecurityContext(this.defaultSubject);
    }

    @Override
    public void init(Properties props) throws Exception {
    }

    @Override
    public UUID login(String username, String password) throws LoginException {
        return (UUID)this.login(this.realmName, username, password);
    }

    @Override
    public Set<String> getLogicalRoles(Principal[] principals, Set<String> logicalRoles) {
        LinkedHashSet<String> roles = new LinkedHashSet<String>(principals.length);
        for (Principal principal : principals) {
            String name = principal.getName();
            if (!logicalRoles.contains(name)) continue;
            roles.add(name);
        }
        return roles;
    }

    @Override
    public void contextEntered(ThreadContext oldContext, ThreadContext newContext) {
        String moduleID = newContext.getBeanContext().getModuleID();
        PolicyContext.setContextID((String)moduleID);
        SecurityContext securityContext = oldContext != null ? oldContext.get(SecurityContext.class) : null;
        BeanContext callingBeanContext = oldContext != null ? oldContext.getBeanContext() : null;
        Subject runAsSubject = this.getRunAsSubject(callingBeanContext);
        if (runAsSubject != null) {
            securityContext = new SecurityContext(runAsSubject);
        } else if (securityContext == null) {
            Identity identity = clientIdentity.get();
            securityContext = identity != null ? new SecurityContext(identity.subject) : this.defaultContext;
        }
        newContext.set(SecurityContext.class, securityContext);
    }

    protected Subject getRunAsSubject(BeanContext callingBeanContext) {
        if (callingBeanContext == null) {
            return null;
        }
        String runAsRole = callingBeanContext.getRunAs();
        return this.createRunAsSubject(runAsRole);
    }

    protected Subject createRunAsSubject(String runAsRole) {
        return this.createSubject(runAsRole);
    }

    @Override
    public void contextExited(ThreadContext exitedContext, ThreadContext reenteredContext) {
        if (reenteredContext == null) {
            PolicyContext.setContextID(null);
        } else {
            PolicyContext.setContextID((String)reenteredContext.getBeanContext().getModuleID());
        }
    }

    protected UUID registerSubject(Subject subject) {
        Identity identity = new Identity(subject);
        UUID token = identity.getToken();
        identities.put(token, identity);
        return token;
    }

    @Override
    public void logout(UUID securityIdentity) throws LoginException {
        Identity identity = identities.get(securityIdentity);
        if (identity == null) {
            throw new LoginException("Identity is not currently logged in: " + securityIdentity);
        }
        identities.remove(securityIdentity);
    }

    protected void unregisterSubject(Object securityIdentity) {
        identities.remove(securityIdentity);
    }

    @Override
    public void associate(UUID securityIdentity) throws LoginException {
        if (clientIdentity.get() != null) {
            throw new LoginException("Thread already associated with a client identity.  Refusing to overwrite.");
        }
        if (securityIdentity == null) {
            throw new NullPointerException("The security token passed in is null");
        }
        Identity identity = identities.get(securityIdentity);
        if (identity == null) {
            throw new LoginException("Identity is not currently logged in: " + securityIdentity);
        }
        clientIdentity.set(identity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UUID disassociate() {
        try {
            Identity identity = clientIdentity.get();
            UUID uUID = identity == null ? null : identity.getToken();
            return uUID;
        }
        finally {
            clientIdentity.remove();
        }
    }

    @Override
    public boolean isCallerInRole(String role) {
        if (role == null) {
            throw new IllegalArgumentException("Role must not be null");
        }
        ThreadContext threadContext = ThreadContext.getThreadContext();
        SecurityContext securityContext = threadContext.get(SecurityContext.class);
        Set<Group> grps = securityContext.subject.getPrincipals(Group.class);
        for (Group grp : grps) {
            if (!grp.getName().equals(role)) continue;
            return true;
        }
        Set<GroupPrincipal> grpsp = securityContext.subject.getPrincipals(GroupPrincipal.class);
        for (GroupPrincipal grp : grpsp) {
            if (!grp.getName().equals(role)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Principal getCallerPrincipal() {
        ThreadContext threadContext = ThreadContext.getThreadContext();
        SecurityContext securityContext = threadContext.get(SecurityContext.class);
        Set<Principal> principals = securityContext.subject.getPrincipals();
        if (!principals.isEmpty()) {
            for (Principal principal : principals) {
                if (!principal.getClass().isAnnotationPresent(CallerPrincipal.class)) continue;
                return principal;
            }
            return principals.iterator().next();
        }
        return null;
    }

    @Override
    public boolean isCallerAuthorized(Method method, InterfaceType type) {
        ThreadContext threadContext = ThreadContext.getThreadContext();
        SecurityContext securityContext = threadContext.get(SecurityContext.class);
        try {
            EJBMethodPermission permission;
            String name;
            BeanContext beanContext = threadContext.getBeanContext();
            String ejbName = beanContext.getEjbName();
            String string = name = type == null ? null : type.getSpecName();
            if ("LocalBean".equals(name) || "LocalBeanHome".equals(name)) {
                name = null;
            }
            if ((permission = new EJBMethodPermission(ejbName, name, method)) != null) {
                securityContext.acc.checkPermission((Permission)permission);
            }
        }
        catch (AccessControlException e) {
            return false;
        }
        return true;
    }

    protected static void installJacc() {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        String providerKey = "javax.security.jacc.PolicyConfigurationFactory.provider";
        try {
            if (System.getProperty("javax.security.jacc.PolicyConfigurationFactory.provider") == null) {
                System.setProperty("javax.security.jacc.PolicyConfigurationFactory.provider", JaccProvider.Factory.class.getName());
                ClassLoader cl = JaccProvider.Factory.class.getClassLoader();
                Thread.currentThread().setContextClassLoader(cl);
            }
            PolicyConfigurationFactory.getPolicyConfigurationFactory();
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not install JACC Policy Configuration Factory: " + System.getProperty("javax.security.jacc.PolicyConfigurationFactory.provider"), e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
        String policyProvider = SystemInstance.get().getOptions().get("javax.security.jacc.policy.provider", JaccProvider.Policy.class.getName());
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Class<?> policyClass = Class.forName(policyProvider, true, classLoader);
            Policy policy = (Policy)policyClass.newInstance();
            policy.refresh();
            Policy.setPolicy(policy);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not install JACC Policy Provider: " + policyProvider, e);
        }
    }

    protected Subject createSubject(String name) {
        if (name == null) {
            return null;
        }
        User user = new User(name);
        Group group = new Group(name);
        group.addMember(user);
        HashSet<Object> principals = new HashSet<Object>();
        principals.add(user);
        principals.add(group);
        return new Subject(true, principals, new HashSet(), new HashSet());
    }

    public static class User
    implements Principal {
        private final String name;

        public User(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    public static class Group
    implements java.security.acl.Group {
        private final List<Principal> members = new ArrayList<Principal>();
        private final String name;

        public Group(String name) {
            this.name = name;
        }

        public boolean addMember(Principal user) {
            return this.members.add(user);
        }

        public boolean removeMember(Principal user) {
            return this.members.remove(user);
        }

        public boolean isMember(Principal member) {
            return this.members.contains(member);
        }

        public Enumeration<? extends Principal> members() {
            return Collections.enumeration(this.members);
        }

        public String getName() {
            return this.name;
        }
    }

    protected static class Identity
    implements Serializable {
        private final Subject subject;
        private final UUID token;

        public Identity(Subject subject) {
            this.subject = subject;
            this.token = UUID.randomUUID();
        }

        public Identity(Subject subject, UUID token) {
            this.subject = subject;
            this.token = token;
        }

        public Subject getSubject() {
            return this.subject;
        }

        public UUID getToken() {
            return this.token;
        }
    }

    protected static final class SecurityContext {
        public final Subject subject;
        public final AccessControlContext acc;

        public SecurityContext(Subject subject) {
            this.subject = subject;
            this.acc = (AccessControlContext)Subject.doAsPrivileged(subject, new PrivilegedAction(){

                public Object run() {
                    return AccessController.getContext();
                }
            }, null);
        }
    }
}

