/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.medic.log.impl.config;

import org.eclipse.virgo.medic.log.LoggingConfiguration;
import org.eclipse.virgo.medic.log.impl.config.ConfigurationLocator;
import org.eclipse.virgo.medic.log.impl.config.ServiceReferenceUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public final class ServiceRegistryConfigurationLocator
implements ConfigurationLocator {
    private final BundleContext bundleContext;
    static final String LOGGING_CONFIGURATION_ID_SERVICE_PROPERTY = "org.eclipse.virgo.medic.log.configuration.id";
    private static final String MEDIC_LOGGING_CONFIGURATION_HEADER = "Medic-LoggingConfiguration";

    public ServiceRegistryConfigurationLocator(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    @Override
    public LoggingConfiguration locateConfiguration(Bundle bundle) {
        String configurationName;
        if (bundle != null && (configurationName = (String)bundle.getHeaders().get(MEDIC_LOGGING_CONFIGURATION_HEADER)) != null) {
            try {
                ServiceReference[] serviceReferences = this.bundleContext.getServiceReferences(LoggingConfiguration.class.getName(), "(org.eclipse.virgo.medic.log.configuration.id=" + configurationName + ")");
                if (serviceReferences != null && serviceReferences.length > 0) {
                    ServiceReference serviceReference = ServiceReferenceUtils.selectServiceReference(serviceReferences);
                    return (LoggingConfiguration)this.bundleContext.getService(serviceReference);
                }
            }
            catch (InvalidSyntaxException invalidSyntaxException) {}
        }
        return null;
    }
}

