/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.monitoring;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.ImmutableDescriptor;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.ReflectionException;
import org.apache.openejb.api.internal.Internal;
import org.apache.openejb.api.jmx.Description;
import org.apache.openejb.api.jmx.MBean;
import org.apache.openejb.api.jmx.ManagedAttribute;
import org.apache.openejb.api.jmx.ManagedOperation;
import org.apache.openejb.api.jmx.NotificationInfo;
import org.apache.openejb.api.jmx.NotificationInfos;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.proxy.ProxyFactory;

public class DynamicMBeanWrapper
implements DynamicMBean {
    public static final Logger logger = Logger.getInstance(LogCategory.OPENEJB_DEPLOY, DynamicMBeanWrapper.class);
    private static final Map<Class<?>, CacheInfo> CACHE = new HashMap();
    private static final Map<Class<?>, Class<? extends Annotation>> OPENEJB_API_TO_JAVAX = new HashMap();
    private final MBeanInfo info;
    private final Map<String, Method> getters = new HashMap<String, Method>();
    private final Map<String, Method> setters = new HashMap<String, Method>();
    private final Map<String, Method> operations = new HashMap<String, Method>();
    private final Object instance;
    private final ClassLoader classloader;

    public DynamicMBeanWrapper(Object givenInstance) {
        this(null, givenInstance);
    }

    public DynamicMBeanWrapper(WebBeansContext wc, Object givenInstance) {
        ProxyFactory pf;
        Class<?> annotatedMBean = givenInstance.getClass();
        if (wc != null && (pf = wc.getProxyFactory()).isProxyInstance(givenInstance)) {
            annotatedMBean = annotatedMBean.getSuperclass();
        }
        this.classloader = annotatedMBean.getClassLoader();
        this.instance = givenInstance;
        CacheInfo cache = CACHE.get(annotatedMBean);
        if (cache == null) {
            Description descr;
            NotificationInfos notifications;
            ArrayList<MBeanAttributeInfo> attributeInfos = new ArrayList<MBeanAttributeInfo>();
            ArrayList<MBeanOperationInfo> operationInfos = new ArrayList<MBeanOperationInfo>();
            ArrayList<MBeanNotificationInfo> notificationInfos = new ArrayList<MBeanNotificationInfo>();
            Description classDescription = this.findAnnotation(annotatedMBean, Description.class);
            String description = this.getDescription(classDescription, "a MBean built by OpenEJB");
            NotificationInfo notification = this.findAnnotation(annotatedMBean, NotificationInfo.class);
            if (notification != null) {
                MBeanNotificationInfo notificationInfo = this.getNotificationInfo(notification);
                notificationInfos.add(notificationInfo);
            }
            if ((notifications = this.findAnnotation(annotatedMBean, NotificationInfos.class)) != null && notifications.value() != null) {
                for (Method method : notifications.value()) {
                    MBeanNotificationInfo notificationInfo = this.getNotificationInfo((NotificationInfo)method);
                    notificationInfos.add(notificationInfo);
                }
            }
            for (Method method : annotatedMBean.getMethods()) {
                int modifiers = method.getModifiers();
                if (method.getDeclaringClass().equals(Object.class) || !Modifier.isPublic(modifiers) || Modifier.isAbstract(modifiers)) continue;
                if (this.findAnnotation(method, ManagedAttribute.class) != null) {
                    String methodName = method.getName();
                    String attrName = methodName;
                    if ((attrName.startsWith("get") && method.getParameterTypes().length == 0 || attrName.startsWith("set") && method.getParameterTypes().length == 1) && attrName.length() > 3) {
                        attrName = (attrName = attrName.substring(3)).length() > 1 ? Character.toLowerCase(attrName.charAt(0)) + attrName.substring(1) : attrName.toLowerCase();
                    } else {
                        logger.warning("ignoring attribute " + method.getName() + " for " + annotatedMBean.getName());
                    }
                    if (methodName.startsWith("get")) {
                        this.getters.put(attrName, method);
                        continue;
                    }
                    if (!methodName.startsWith("set")) continue;
                    this.setters.put(attrName, method);
                    continue;
                }
                if (this.findAnnotation(method, ManagedOperation.class) == null) continue;
                this.operations.put(method.getName(), method);
                String operationDescr = "";
                Description descr2 = this.findAnnotation(method, Description.class);
                if (descr2 != null) {
                    operationDescr = this.getDescription(descr2, "-");
                }
                operationInfos.add(new MBeanOperationInfo(operationDescr, method));
            }
            for (Map.Entry<String, Method> e : this.getters.entrySet()) {
                String key = e.getKey();
                Method method = e.getValue();
                String attrDescr = "";
                descr = this.findAnnotation(method, Description.class);
                if (descr != null) {
                    attrDescr = this.getDescription(descr, "-");
                }
                try {
                    attributeInfos.add(new MBeanAttributeInfo(key, attrDescr, method, this.setters.get(key)));
                }
                catch (IntrospectionException ex) {
                    logger.warning("can't manage " + key + " for " + method.getName(), ex);
                }
            }
            for (Map.Entry<String, Method> e : this.setters.entrySet()) {
                String key = e.getKey();
                if (this.getters.get(key) != null) continue;
                Method method = e.getValue();
                String attrDescr = "";
                descr = this.findAnnotation(method, Description.class);
                if (descr != null) {
                    attrDescr = this.getDescription(descr, "-");
                }
                try {
                    attributeInfos.add(new MBeanAttributeInfo(key, attrDescr, null, this.setters.get(key)));
                }
                catch (IntrospectionException ex) {
                    logger.warning("can't manage " + key + " for " + method.getName(), ex);
                }
            }
            this.info = new MBeanInfo(annotatedMBean.getName(), description, attributeInfos.toArray(new MBeanAttributeInfo[attributeInfos.size()]), null, operationInfos.toArray(new MBeanOperationInfo[operationInfos.size()]), notificationInfos.toArray(new MBeanNotificationInfo[notificationInfos.size()]));
            if (annotatedMBean.getAnnotation(Internal.class) != null) {
                CACHE.put(annotatedMBean, new CacheInfo(this.info, this.getters, this.setters, this.operations));
            }
        } else {
            this.info = cache.mBeanInfo;
            this.getters.putAll(cache.getters);
            this.setters.putAll(cache.setters);
            this.operations.putAll(cache.operations);
        }
    }

    private <T extends Annotation> T findAnnotation(Method method, Class<T> searchedAnnotation) {
        Class<? extends Annotation> clazz;
        Annotation javaxAnnotation;
        T annotation = method.getAnnotation(searchedAnnotation);
        if (annotation != null) {
            return annotation;
        }
        if (OPENEJB_API_TO_JAVAX.containsKey(searchedAnnotation) && (javaxAnnotation = method.getAnnotation(clazz = OPENEJB_API_TO_JAVAX.get(searchedAnnotation))) != null) {
            return DynamicMBeanWrapper.annotationProxy(javaxAnnotation, searchedAnnotation);
        }
        return null;
    }

    private <T extends Annotation> T findAnnotation(Class<?> annotatedMBean, Class<T> searchedAnnotation) {
        Class<? extends Annotation> clazz;
        Annotation javaxAnnotation;
        T annotation = annotatedMBean.getAnnotation(searchedAnnotation);
        if (annotation != null) {
            return annotation;
        }
        if (OPENEJB_API_TO_JAVAX.containsKey(searchedAnnotation) && (javaxAnnotation = annotatedMBean.getAnnotation(clazz = OPENEJB_API_TO_JAVAX.get(searchedAnnotation))) != null) {
            return DynamicMBeanWrapper.annotationProxy(javaxAnnotation, searchedAnnotation);
        }
        return null;
    }

    private static <T extends Annotation> T annotationProxy(Object javaxAnnotation, Class<T> clazz) {
        return (T)((Annotation)Proxy.newProxyInstance(DynamicMBeanWrapper.class.getClassLoader(), new Class[]{clazz}, (InvocationHandler)new AnnotationHandler(javaxAnnotation)));
    }

    private MBeanNotificationInfo getNotificationInfo(NotificationInfo n) {
        String description = this.getDescription(n.description(), "-");
        return new MBeanNotificationInfo(n.types(), n.notificationClass().getName(), description, new ImmutableDescriptor(n.descriptorFields()));
    }

    private String getDescription(Description d, String defaultValue) {
        if (d != null) {
            if (d.bundleBaseName() != null && d.key() != null) {
                try {
                    return ResourceBundle.getBundle(d.bundleBaseName()).getString(d.key());
                }
                catch (RuntimeException re) {
                    return d.value();
                }
            }
            return d.value();
        }
        return defaultValue;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return this.info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (this.getters.containsKey(attribute)) {
            ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.classloader);
            try {
                Object object = this.getters.get(attribute).invoke(this.instance, new Object[0]);
                return object;
            }
            catch (IllegalArgumentException e) {
                logger.error("can't get " + attribute + " value", e);
            }
            catch (IllegalAccessException e) {
                logger.error("can't get " + attribute + " value", e);
            }
            catch (InvocationTargetException e) {
                logger.error("can't get " + attribute + " value", e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldCl);
            }
        }
        throw new AttributeNotFoundException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (this.setters.containsKey(attribute.getName())) {
            ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.classloader);
            try {
                this.setters.get(attribute.getName()).invoke(this.instance, attribute.getValue());
            }
            catch (IllegalArgumentException e) {
                logger.error("can't set " + attribute + " value", e);
            }
            catch (IllegalAccessException e) {
                logger.error("can't set " + attribute + " value", e);
            }
            catch (InvocationTargetException e) {
                logger.error("can't set " + attribute + " value", e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldCl);
            }
        } else {
            throw new AttributeNotFoundException();
        }
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        AttributeList list = new AttributeList();
        for (String n : attributes) {
            try {
                list.add(new Attribute(n, this.getAttribute(n)));
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        return list;
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        AttributeList list = new AttributeList();
        for (Object o : attributes) {
            Attribute attr = (Attribute)o;
            try {
                this.setAttribute(attr);
                list.add(attr);
            }
            catch (Exception ignore) {}
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if (this.operations.containsKey(actionName)) {
            ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.classloader);
            try {
                Object object = this.operations.get(actionName).invoke(this.instance, params);
                return object;
            }
            catch (IllegalArgumentException e) {
                logger.error(actionName + "can't be invoked", e);
            }
            catch (IllegalAccessException e) {
                logger.error(actionName + "can't be invoked", e);
            }
            catch (InvocationTargetException e) {
                logger.error(actionName + "can't be invoked", e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldCl);
            }
        }
        throw new MBeanException(new IllegalArgumentException(), actionName + " doesn't exist");
    }

    static {
        ClassLoader loader = DynamicMBeanWrapper.class.getClassLoader();
        try {
            OPENEJB_API_TO_JAVAX.put(MBean.class, loader.loadClass("javax.management.MBean"));
            OPENEJB_API_TO_JAVAX.put(Description.class, loader.loadClass("javax.management.Description"));
            OPENEJB_API_TO_JAVAX.put(ManagedOperation.class, loader.loadClass("javax.management.ManagedOperation"));
            OPENEJB_API_TO_JAVAX.put(ManagedAttribute.class, loader.loadClass("javax.management.ManagedAttribute"));
            OPENEJB_API_TO_JAVAX.put(NotificationInfo.class, loader.loadClass("javax.management.NotificationInfo"));
            OPENEJB_API_TO_JAVAX.put(NotificationInfos.class, loader.loadClass("javax.management.NotificationInfos"));
        }
        catch (ClassNotFoundException cnfe) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    private static class AnnotationHandler
    implements InvocationHandler {
        private final Object delegate;

        public AnnotationHandler(Object javaxAnnotation) {
            this.delegate = javaxAnnotation;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object result = null;
            for (Method mtd : this.delegate.getClass().getMethods()) {
                if (!mtd.getName().equals(method.getName())) continue;
                result = mtd.invoke(this.delegate, args);
                break;
            }
            if (result == null) {
                return null;
            }
            if (result.getClass().isArray()) {
                Object[] array = (Object[])result;
                if (array.length == 0 || !OPENEJB_API_TO_JAVAX.containsValue(array[0].getClass())) {
                    return array;
                }
                Object[] translated = new Object[array.length];
                for (int i = 0; i < translated.length; ++i) {
                    translated[i] = DynamicMBeanWrapper.annotationProxy(array[i], (Class)OPENEJB_API_TO_JAVAX.get(array[i].getClass()));
                }
            }
            return result;
        }
    }

    private static class CacheInfo {
        public final MBeanInfo mBeanInfo;
        public final Map<String, Method> getters;
        public final Map<String, Method> setters;
        public final Map<String, Method> operations;

        private CacheInfo(MBeanInfo mBeanInfo, Map<String, Method> getters, Map<String, Method> setters, Map<String, Method> operations) {
            this.mBeanInfo = mBeanInfo;
            this.getters = getters;
            this.setters = setters;
            this.operations = operations;
        }
    }
}

