/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.web.core.internal;

import java.io.IOException;
import java.util.Locale;
import org.eclipse.virgo.kernel.install.artifact.BundleInstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.InstallArtifact;
import org.eclipse.virgo.kernel.install.environment.InstallEnvironment;
import org.eclipse.virgo.kernel.install.pipeline.stage.transform.Transformer;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.nano.deployer.api.core.DeploymentException;
import org.eclipse.virgo.nano.serviceability.dump.DumpCoordinator;
import org.eclipse.virgo.util.common.GraphNode;
import org.eclipse.virgo.util.osgi.manifest.BundleManifest;
import org.eclipse.virgo.web.core.internal.WebContainerUtils;

final class WarDetectingTransformer
implements Transformer {
    private static final String WAR_EXTENSION = ".war";
    private static final String WAR_HEADER = "org-eclipse-virgo-web-war-detected";
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;

    WarDetectingTransformer() {
        try {
            try {
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public void transform(GraphNode<InstallArtifact> installGraph, InstallEnvironment installEnvironment) throws DeploymentException {
        try {
            installGraph.visit((GraphNode.ExceptionThrowingDirectedAcyclicGraphVisitor)new GraphNode.ExceptionThrowingDirectedAcyclicGraphVisitor<InstallArtifact, DeploymentException>(){
                private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
                {
                    try {
                        try {
                        }
                        catch (RuntimeException runtimeException) {
                            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                            throw runtimeException;
                        }
                        return;
                    }
                    catch (RuntimeException runtimeException) {
                        DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                        throw runtimeException;
                    }
                }

                public boolean visit(GraphNode<InstallArtifact> node) throws DeploymentException {
                    try {
                        WarDetectingTransformer.access$0(WarDetectingTransformer.this, (InstallArtifact)node.getValue());
                        return true;
                    }
                    catch (RuntimeException runtimeException) {
                        DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                        throw runtimeException;
                    }
                }

                public static /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$localAspectOf() {
                    return ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
                }

                static {
                    ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.web.core.internal.WarDetectingTransformer$1");
                }
            });
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void detectWar(InstallArtifact installArtifact) throws DeploymentException {
        try {
            if (installArtifact instanceof BundleInstallArtifact && this.hasWarSuffix(installArtifact)) {
                BundleInstallArtifact bundleInstallArtifact = (BundleInstallArtifact)installArtifact;
                try {
                    BundleManifest bundleManifest = bundleInstallArtifact.getBundleManifest();
                    if (!WebContainerUtils.isWebApplicationBundle(bundleManifest)) {
                        bundleManifest.setHeader(WAR_HEADER, "true");
                    }
                }
                catch (IOException iOException) {}
            }
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private boolean hasWarSuffix(InstallArtifact installArtifact) {
        try {
            return installArtifact.getArtifactFS().getFile().getName().toLowerCase(Locale.ENGLISH).endsWith(WAR_EXTENSION);
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    static /* synthetic */ void access$0(WarDetectingTransformer arg0, InstallArtifact arg1) throws DeploymentException {
        try {
            arg0.detectWar(arg1);
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public static /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$localAspectOf() {
        return ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    }

    static {
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.web.core.internal.WarDetectingTransformer");
    }
}

