/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.management.console.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import java.util.Scanner;
import org.eclipse.virgo.management.console.internal.ContentURLFetcher;

public class Parser {
    private static final String START_DECLARATION = "<!--@";
    private static final String END_DECLARATION = "@-->";
    private static final char IMPORT = '&';
    private static final char SET = '>';
    private static final char LOOKUP = '<';
    private static final char EVALUATE = '?';
    private final Map<String, String> pageContext;
    private final PrintWriter out;
    private final ContentURLFetcher urlFetcher;

    public Parser(PrintWriter out, ContentURLFetcher urlFetcher, Map<String, String> modelData) {
        this.out = out;
        this.urlFetcher = urlFetcher;
        this.pageContext = modelData;
    }

    public final void parse(InputStream in) throws IOException {
        Scanner scanner = new Scanner(in);
        while (scanner.hasNextLine()) {
            String parsedLine = this.parseLine(scanner.nextLine());
            if (parsedLine == null || parsedLine.trim().isEmpty()) continue;
            this.out.append(parsedLine);
            this.out.append('\n');
        }
    }

    private String parseLine(String line) throws IOException {
        int endOffset;
        int startOffset = line.indexOf(START_DECLARATION);
        if (startOffset > -1 && (endOffset = line.indexOf(END_DECLARATION)) > startOffset) {
            String arg = line.substring(startOffset + START_DECLARATION.length() + 1, endOffset);
            String newValue = "";
            switch (line.charAt(startOffset + START_DECLARATION.length())) {
                case '&': {
                    newValue = this.doImport(arg);
                    break;
                }
                case '>': {
                    newValue = this.doSet(arg);
                    break;
                }
                case '<': {
                    newValue = this.doLookup(arg);
                    break;
                }
                case '?': {
                    newValue = this.doEvaluate(arg);
                    break;
                }
            }
            line = String.format("%s%s%s", line.substring(0, startOffset), newValue, line.substring(endOffset + END_DECLARATION.length()));
            line = this.parseLine(line);
        }
        return line;
    }

    private String doImport(String arg) throws IOException {
        if ((arg = this.resolveField(arg)).charAt(0) != '/') {
            arg = String.valueOf('/') + arg;
        }
        URL content = this.urlFetcher.getRequestedContentURL(arg);
        URLConnection resourceConn = content.openConnection();
        InputStream in = resourceConn.getInputStream();
        try {
            this.parse(in);
        }
        finally {
            in.close();
        }
        return "";
    }

    private String doSet(String arg) {
        int splitOffSet = arg.indexOf(58);
        if (splitOffSet >= 0) {
            this.pageContext.put(arg.substring(0, splitOffSet), arg.substring(splitOffSet + 1));
        }
        return "";
    }

    private String doLookup(String arg) {
        String newValue = (String)this.pageContext.get(arg);
        if (newValue == null) {
            return "";
        }
        return newValue;
    }

    private String doEvaluate(String arg) {
        boolean result;
        int equalsOffset = arg.indexOf(61);
        int thenOffset = arg.indexOf(58);
        int elseOffset = arg.indexOf(58, thenOffset + 1);
        if (equalsOffset >= 0 && equalsOffset < thenOffset) {
            String query = this.resolveField(arg.substring(0, equalsOffset));
            String comparator = this.resolveField(arg.substring(equalsOffset + 1, thenOffset));
            result = query.equals(comparator);
        } else {
            String query = this.resolveField(arg.substring(0, thenOffset));
            result = Boolean.valueOf(query);
        }
        if (result) {
            return this.resolveField(arg.substring(thenOffset + 1, elseOffset));
        }
        return elseOffset + 1 == arg.length() ? "" : this.resolveField(arg.substring(elseOffset + 1));
    }

    private String resolveField(String field) {
        if (field.charAt(0) == '<') {
            field = this.doLookup(field.substring(1));
        } else if (field.charAt(0) == '>') {
            field = this.doSet(field).substring(1);
        }
        return field;
    }
}

