/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sessions.coordination.jms;

import java.util.Hashtable;
import javax.jms.Topic;
import javax.jms.TopicConnectionFactory;
import javax.naming.Context;
import javax.naming.NamingException;
import org.eclipse.persistence.exceptions.RemoteCommandManagerException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.sessions.coordination.jms.JMSTopicRemoteConnection;
import org.eclipse.persistence.sessions.coordination.RemoteCommandManager;
import org.eclipse.persistence.sessions.coordination.broadcast.BroadcastTransportManager;

public class JMSPublishingTransportManager
extends BroadcastTransportManager {
    protected String connectionFactoryName;
    protected boolean reuseJMSTopicPublisher = false;
    public static final String DEFAULT_TOPIC = "jms/EclipseLinkTopic";
    public static final String DEFAULT_CONNECTION_FACTORY = "jms/EclipseLinkTopicConnectionFactory";

    public JMSPublishingTransportManager(RemoteCommandManager rcm) {
        super(rcm);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected JMSTopicRemoteConnection createConnection(boolean isLocalConnectionBeingCreated) throws RemoteCommandManagerException {
        JMSTopicRemoteConnection jMSTopicRemoteConnection;
        Context remoteHostContext = null;
        try {
            remoteHostContext = this.getRemoteHostContext(this.getTopicHostUrl());
            TopicConnectionFactory connectionFactory = this.getTopicConnectionFactory(remoteHostContext);
            Topic topic = this.getTopic(remoteHostContext);
            jMSTopicRemoteConnection = new JMSTopicRemoteConnection(this.rcm, connectionFactory, topic, isLocalConnectionBeingCreated, this.reuseJMSTopicPublisher);
            if (remoteHostContext == null) return jMSTopicRemoteConnection;
        }
        catch (Exception ex) {
            try {
                RemoteCommandManagerException rcmException;
                if (isLocalConnectionBeingCreated) {
                    rcmException = RemoteCommandManagerException.errorCreatingLocalJMSConnection(this.topicName, this.connectionFactoryName, ex);
                    throw rcmException;
                }
                rcmException = RemoteCommandManagerException.errorCreatingJMSConnection(this.topicName, this.connectionFactoryName, ex);
                throw rcmException;
            }
            catch (Throwable throwable) {
                if (remoteHostContext == null) throw throwable;
                try {
                    remoteHostContext.close();
                    throw throwable;
                }
                catch (NamingException namingException) {}
                throw throwable;
            }
        }
        try {
            remoteHostContext.close();
            return jMSTopicRemoteConnection;
        }
        catch (NamingException namingException) {}
        return jMSTopicRemoteConnection;
    }

    @Override
    public void createConnections() {
        this.createExternalConnection();
        this.createLocalConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createExternalConnection() {
        Hashtable hashtable = this.connectionsToExternalServices;
        synchronized (hashtable) {
            if (this.connectionsToExternalServices.isEmpty()) {
                try {
                    this.connectionsToExternalServices.put(this.rcm.getServiceId().getId(), this.createConnection(false));
                }
                catch (RemoteCommandManagerException rcmException) {
                    this.rcm.handleException(rcmException);
                }
            }
        }
    }

    @Override
    public void createLocalConnection() {
        if (this.localConnection == null) {
            this.localConnection = new JMSTopicRemoteConnection(this.rcm);
        }
    }

    @Override
    public Hashtable getConnectionsToExternalServicesForCommandPropagation() {
        if (this.getConnectionsToExternalServices().isEmpty() && !this.rcm.isStopped()) {
            this.createExternalConnection();
        }
        return super.getConnectionsToExternalServicesForCommandPropagation();
    }

    public boolean getReuseJMSTopicPublisher() {
        return this.reuseJMSTopicPublisher;
    }

    protected Topic getTopic(Context remoteHostContext) {
        try {
            return (Topic)remoteHostContext.lookup(this.topicName);
        }
        catch (NamingException e) {
            RemoteCommandManagerException rcmException = RemoteCommandManagerException.errorLookingUpRemoteConnection(this.topicName, this.rcm.getUrl(), e);
            this.rcm.handleException(rcmException);
            throw rcmException;
        }
    }

    protected TopicConnectionFactory getTopicConnectionFactory(Context remoteHostContext) {
        try {
            return (TopicConnectionFactory)remoteHostContext.lookup(this.connectionFactoryName);
        }
        catch (NamingException e) {
            RemoteCommandManagerException rcmException = RemoteCommandManagerException.errorLookingUpRemoteConnection(this.connectionFactoryName, this.rcm.getUrl(), e);
            this.rcm.handleException(rcmException);
            throw rcmException;
        }
    }

    public String getTopicConnectionFactoryName() {
        return this.connectionFactoryName;
    }

    public String getTopicHostUrl() {
        return (String)this.getRemoteContextProperties().get("java.naming.provider.url");
    }

    @Override
    public void initialize() {
        super.initialize();
        this.topicName = DEFAULT_TOPIC;
        this.connectionFactoryName = DEFAULT_CONNECTION_FACTORY;
    }

    @Override
    public void removeLocalConnection() {
    }

    @Override
    public void setNamingServiceType(int serviceType) {
        if (serviceType != 0) {
            throw ValidationException.operationNotSupported("setNamingServiceType");
        }
    }

    public void setShouldReuseJMSTopicPublisher(boolean reuseJMSTopicPublisher) {
        this.reuseJMSTopicPublisher = reuseJMSTopicPublisher;
    }

    public void setTopicConnectionFactoryName(String newTopicConnectionFactoryName) {
        this.connectionFactoryName = newTopicConnectionFactoryName;
    }

    public void setTopicHostUrl(String jmsHostUrl) {
        this.getRemoteContextProperties().put("java.naming.provider.url", jmsHostUrl);
        this.rcm.getServiceId().setURL(jmsHostUrl);
    }
}

