/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.agent.dm.internal;

import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.gemini.blueprint.context.event.OsgiBundleApplicationContextListener;
import org.eclipse.virgo.kernel.agent.dm.internal.BlueprintEventPostingOsgiBundleApplicationContextListener;
import org.eclipse.virgo.kernel.agent.dm.internal.DeployerFailureListener;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.medic.eventlog.EventLoggerFactory;
import org.eclipse.virgo.util.osgi.ServiceRegistrationTracker;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventHandler;

public final class AgentActivator {
    private static final String AGENT_DM_START_TRACKER = "agentDMStartTracker";
    private final ServiceRegistrationTracker registrationTracker = new ServiceRegistrationTracker();

    public void activate(ComponentContext context) {
        this.registerSpringDmToBlueprintEventAdapter(context.getBundleContext());
        context.enableComponent(AGENT_DM_START_TRACKER);
    }

    private void registerSpringDmToBlueprintEventAdapter(BundleContext context) {
        this.registerBlueprintEventPostingOsgiBundleApplicationContextListener(context);
        this.registerDeployerFailureListener(context);
    }

    private void registerBlueprintEventPostingOsgiBundleApplicationContextListener(BundleContext context) {
        EventAdmin eventAdmin = this.getRequiredService(context, EventAdmin.class);
        BlueprintEventPostingOsgiBundleApplicationContextListener listener = new BlueprintEventPostingOsgiBundleApplicationContextListener(eventAdmin);
        this.registrationTracker.track(context.registerService(OsgiBundleApplicationContextListener.class.getName(), (Object)listener, null));
    }

    private void registerDeployerFailureListener(BundleContext context) {
        EventLoggerFactory eventLoggerFactory = this.getRequiredService(context, EventLoggerFactory.class);
        EventLogger eventLogger = eventLoggerFactory.createEventLogger(context.getBundle());
        DeployerFailureListener failureListener = new DeployerFailureListener(eventLogger);
        Hashtable<String, String[]> props = new Hashtable<String, String[]>();
        ((Dictionary)props).put("event.topics", new String[]{"org/osgi/service/blueprint/container/*"});
        this.registrationTracker.track(context.registerService(EventHandler.class.getName(), (Object)failureListener, props));
    }

    public void deactivate(ComponentContext context) throws Exception {
        this.registrationTracker.unregisterAll();
    }

    private <T> T getRequiredService(BundleContext context, Class<T> clazz) {
        Object result = null;
        ServiceReference ref = context.getServiceReference(clazz);
        if (ref != null) {
            result = context.getService(ref);
        }
        if (result == null) {
            throw new IllegalStateException("Unable to access required service of type '" + clazz.getName() + "' from bundle '" + context.getBundle().getSymbolicName() + "'");
        }
        return (T)result;
    }
}

