/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.repository.codec;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.eclipse.virgo.repository.ArtifactDescriptor;
import org.eclipse.virgo.repository.Attribute;
import org.eclipse.virgo.repository.IndexFormatException;
import org.eclipse.virgo.repository.codec.RepositoryCodec;
import org.eclipse.virgo.repository.internal.StandardArtifactDescriptor;
import org.eclipse.virgo.repository.internal.StandardAttribute;
import org.osgi.framework.Version;

public final class XMLRepositoryCodec
implements RepositoryCodec {
    private static final String INDEX_NAMESPACE = "http://www.springsource.org/schema/repository";
    private static final String TAG_REPOSITORY = "repository";
    private static final String TAG_ARTIFACT = "artifact";
    private static final String ATT_URI = "uri";
    private static final String ATT_TYPE = "type";
    private static final String ATT_NAME = "name";
    private static final String ATT_VERSION = "version";
    private static final String ATT_FILENAME = "filename";
    private static final String TAG_ATTRIBUTE = "attribute";
    private static final String ATT_VALUE = "value";
    private static final String TAG_PROPERTY = "property";
    private static final String TAG_VALUE = "value";

    @Override
    public void write(Set<? extends ArtifactDescriptor> artifactDescriptors, OutputStream outputStream) {
        XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
        XMLStreamWriter writer = null;
        try {
            try {
                writer = outputFactory.createXMLStreamWriter(outputStream);
                writer.writeStartDocument();
                this.writeIndex(writer, artifactDescriptors);
                writer.writeEndDocument();
            }
            catch (FactoryConfigurationError e) {
                throw new RuntimeException("Could not open XML Streaming factory", e);
            }
            catch (XMLStreamException e) {
                throw new RuntimeException("Could not write XML document", e);
            }
        }
        catch (Throwable throwable) {
            if (writer != null) {
                try {
                    writer.flush();
                    writer.close();
                }
                catch (XMLStreamException xMLStreamException) {}
            }
            throw throwable;
        }
        if (writer != null) {
            try {
                writer.flush();
                writer.close();
            }
            catch (XMLStreamException xMLStreamException) {}
        }
    }

    private void writeIndex(XMLStreamWriter writer, Set<? extends ArtifactDescriptor> artifactDescriptors) throws XMLStreamException {
        writer.writeStartElement(TAG_REPOSITORY);
        writer.writeDefaultNamespace(INDEX_NAMESPACE);
        for (ArtifactDescriptor artifactDescriptor : artifactDescriptors) {
            this.writeArtifactDescriptor(writer, artifactDescriptor);
        }
        writer.writeEndElement();
    }

    private void writeArtifactDescriptor(XMLStreamWriter writer, ArtifactDescriptor artifactDescriptor) throws XMLStreamException {
        writer.writeStartElement(TAG_ARTIFACT);
        writer.writeAttribute(ATT_URI, artifactDescriptor.getUri().toString());
        writer.writeAttribute(ATT_TYPE, artifactDescriptor.getType());
        writer.writeAttribute(ATT_NAME, artifactDescriptor.getName());
        writer.writeAttribute(ATT_VERSION, artifactDescriptor.getVersion().toString());
        if (artifactDescriptor.getFilename() != null) {
            writer.writeAttribute(ATT_FILENAME, artifactDescriptor.getFilename());
        }
        for (Attribute attribute : artifactDescriptor.getAttributes()) {
            this.writeAttribute(writer, attribute);
        }
        writer.writeEndElement();
    }

    private void writeAttribute(XMLStreamWriter writer, Attribute attribute) throws XMLStreamException {
        writer.writeStartElement(TAG_ATTRIBUTE);
        writer.writeAttribute(ATT_NAME, attribute.getKey());
        if (attribute.getValue() != null && !attribute.getValue().isEmpty()) {
            writer.writeAttribute("value", attribute.getValue());
        }
        for (Map.Entry<String, Set<String>> property : attribute.getProperties().entrySet()) {
            this.writeProperty(writer, property.getKey(), property.getValue());
        }
        writer.writeEndElement();
    }

    private void writeProperty(XMLStreamWriter writer, String name, Set<String> values) throws XMLStreamException {
        writer.writeStartElement(TAG_PROPERTY);
        writer.writeAttribute(ATT_NAME, name);
        for (String value : values) {
            this.writePropertyValue(writer, value);
        }
        writer.writeEndElement();
    }

    private void writePropertyValue(XMLStreamWriter writer, String value) throws XMLStreamException {
        writer.writeStartElement("value");
        writer.writeCharacters(value);
        writer.writeEndElement();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Set<ArtifactDescriptor> read(InputStream inputStream) throws IndexFormatException {
        Set<ArtifactDescriptor> set;
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        XMLStreamReader reader = null;
        try {
            reader = inputFactory.createXMLStreamReader(inputStream);
            reader.nextTag();
            set = this.readIndex(reader);
            if (reader == null) return set;
        }
        catch (XMLStreamException e) {
            try {
                throw new IndexFormatException("Could read read XML document", e);
            }
            catch (Throwable throwable) {
                if (reader == null) throw throwable;
                try {
                    reader.close();
                    throw throwable;
                }
                catch (XMLStreamException xMLStreamException) {}
                throw throwable;
            }
        }
        try {
            reader.close();
            return set;
        }
        catch (XMLStreamException xMLStreamException) {}
        return set;
    }

    private Set<ArtifactDescriptor> readIndex(XMLStreamReader reader) throws XMLStreamException {
        HashSet<ArtifactDescriptor> descriptors = new HashSet<ArtifactDescriptor>();
        reader.nextTag();
        while (reader.isStartElement() && TAG_ARTIFACT.equals(reader.getLocalName())) {
            descriptors.add(this.readArtifactDescriptor(reader));
            reader.nextTag();
        }
        return descriptors;
    }

    private ArtifactDescriptor readArtifactDescriptor(XMLStreamReader reader) throws XMLStreamException {
        URI uri = URI.create(reader.getAttributeValue(null, ATT_URI));
        String type = reader.getAttributeValue(null, ATT_TYPE);
        String name = reader.getAttributeValue(null, ATT_NAME);
        Version version = new Version(reader.getAttributeValue(null, ATT_VERSION));
        String filename = reader.getAttributeValue(null, ATT_FILENAME);
        HashSet<Attribute> attributes = new HashSet<Attribute>();
        reader.nextTag();
        while (reader.isStartElement() && TAG_ATTRIBUTE.equals(reader.getLocalName())) {
            attributes.add(this.readAttribute(reader));
            reader.nextTag();
        }
        return new StandardArtifactDescriptor(uri, type, name, version, filename, attributes);
    }

    private Attribute readAttribute(XMLStreamReader reader) throws XMLStreamException {
        String name = reader.getAttributeValue(null, ATT_NAME);
        String value = reader.getAttributeValue(null, "value");
        if (value == null) {
            value = "";
        }
        HashMap<String, Set<String>> properties = new HashMap<String, Set<String>>();
        reader.nextTag();
        while (reader.isStartElement() && TAG_PROPERTY.equals(reader.getLocalName())) {
            Property p = this.readProperty(reader);
            properties.put(p.getName(), p.getValues());
            reader.nextTag();
        }
        return new StandardAttribute(name, value, properties);
    }

    private Property readProperty(XMLStreamReader reader) throws XMLStreamException {
        String name = reader.getAttributeValue(null, ATT_NAME);
        HashSet<String> values = new HashSet<String>();
        reader.nextTag();
        while (reader.isStartElement() && "value".equals(reader.getLocalName())) {
            values.add(this.readPropertyValue(reader));
            reader.nextTag();
        }
        return new Property(name, values);
    }

    private String readPropertyValue(XMLStreamReader reader) throws XMLStreamException {
        reader.next();
        String value = reader.getText();
        reader.next();
        return value;
    }

    private static class Property {
        private final String name;
        private final Set<String> values;

        public Property(String name, Set<String> values) {
            this.name = name;
            this.values = values;
        }

        public String getName() {
            return this.name;
        }

        public Set<String> getValues() {
            return this.values;
        }
    }
}

