/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.osgi.security;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jolokia.osgi.security.Authenticator;
import org.jolokia.osgi.security.DefaultHttpContext;

public class BasicAuthenticationHttpContext
extends DefaultHttpContext {
    private final String realm;
    private final Authenticator authenticator;

    public BasicAuthenticationHttpContext(String pRealm, Authenticator pAuthenticator) {
        this.realm = pRealm;
        this.authenticator = pAuthenticator;
    }

    public boolean handleSecurity(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!this.authenticator.authenticate(request)) {
            response.setHeader("WWW-Authenticate", "BASIC realm=\"" + this.realm + "\"");
            response.sendError(401);
            return false;
        }
        return true;
    }
}

