/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.nano.deployer.hot;

import java.io.File;
import org.eclipse.virgo.util.io.FileSystemChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class WatchTask
implements Runnable {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final int scanIntervalMillis;
    private final FileSystemChecker checker;
    private final File watchDir;

    WatchTask(FileSystemChecker checker, File watchDir, int scanIntervalMillis) {
        this.checker = checker;
        this.watchDir = watchDir;
        this.scanIntervalMillis = scanIntervalMillis;
    }

    @Override
    public void run() {
        while (!Thread.currentThread().isInterrupted()) {
            try {
                Thread.sleep(this.scanIntervalMillis);
            }
            catch (InterruptedException interruptedException) {
                break;
            }
            try {
                this.checker.check();
            }
            catch (Throwable e) {
                this.logger.error("Error watching directory '{}'", (Object)e, (Object)this.watchDir.getAbsolutePath());
            }
        }
    }
}

