/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.repository.internal.eventlog;

import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.medic.eventlog.Level;
import org.eclipse.virgo.medic.eventlog.LogEvent;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public final class DynamicDelegationEventLogger
implements EventLogger {
    private final ServiceTracker<EventLogger, EventLogger> serviceTracker;
    private final EventLoggerTracker eventLoggerTracker;

    public DynamicDelegationEventLogger(BundleContext bundleContext) {
        this.eventLoggerTracker = new EventLoggerTracker(bundleContext);
        this.serviceTracker = new ServiceTracker(bundleContext, EventLogger.class.getName(), (ServiceTrackerCustomizer)this.eventLoggerTracker);
    }

    public void start() {
        this.serviceTracker.open();
    }

    public void stop() {
        this.serviceTracker.close();
    }

    public void log(LogEvent logEvent, Object ... inserts) {
        this.log(logEvent.getEventCode(), logEvent.getLevel(), null, inserts);
    }

    public void log(String code, Level level, Object ... inserts) {
        this.log(code, level, null, inserts);
    }

    public void log(LogEvent logEvent, Throwable throwable, Object ... inserts) {
        this.log(logEvent.getEventCode(), logEvent.getLevel(), throwable, inserts);
    }

    public void log(String code, Level level, Throwable throwable, Object ... inserts) {
        Object[] objects = this.serviceTracker.getServices();
        if (objects != null) {
            Object[] objectArray = objects;
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                ((EventLogger)object).log(code, level, throwable, inserts);
                ++n2;
            }
        }
    }

    private static final class EventLoggerTracker
    implements ServiceTrackerCustomizer<EventLogger, EventLogger> {
        private final BundleContext bundleContext;

        private EventLoggerTracker(BundleContext bundleContext) {
            this.bundleContext = bundleContext;
        }

        public EventLogger addingService(ServiceReference<EventLogger> reference) {
            EventLogger service = (EventLogger)this.bundleContext.getService(reference);
            return service;
        }

        public void modifiedService(ServiceReference<EventLogger> reference, EventLogger service) {
        }

        public void removedService(ServiceReference<EventLogger> reference, EventLogger service) {
            this.bundleContext.ungetService(reference);
        }
    }
}

