/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.boot;

import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import org.eclipse.jetty.osgi.boot.internal.webapp.BundleFileLocatorHelperFactory;
import org.eclipse.jetty.osgi.boot.utils.internal.PackageAdminServiceTracker;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.MetaInfConfiguration;
import org.eclipse.jetty.webapp.WebAppContext;
import org.osgi.framework.Bundle;

public class OSGiMetaInfConfiguration
extends MetaInfConfiguration {
    private static final Logger LOG = Log.getLogger(OSGiMetaInfConfiguration.class);

    public void preConfigure(WebAppContext context) throws Exception {
        Bundle[] fragments;
        ArrayList<Resource> frags = (ArrayList<Resource>)context.getAttribute("org.eclipse.jetty.webFragments");
        ArrayList<Resource> resfrags = (ArrayList<Resource>)context.getAttribute("org.eclipse.jetty.resources");
        ArrayList<Resource> tldfrags = (ArrayList<Resource>)context.getAttribute("org.eclipse.jetty.tlds");
        for (Bundle frag : fragments = PackageAdminServiceTracker.INSTANCE.getFragmentsAndRequiredBundles((Bundle)context.getAttribute("osgi-bundle"))) {
            URL webFrag = frag.getEntry("/META-INF/web-fragment.xml");
            Enumeration resEnum = frag.findEntries("/META-INF/resources", "*", true);
            Enumeration tldEnum = frag.findEntries("/META-INF", "*.tld", false);
            if (webFrag == null && (resEnum == null || !resEnum.hasMoreElements()) && (tldEnum == null || !tldEnum.hasMoreElements())) continue;
            try {
                URL resourcesEntry;
                if (webFrag != null) {
                    if (frags == null) {
                        frags = new ArrayList<Resource>();
                        context.setAttribute("org.eclipse.jetty.webFragments", frags);
                    }
                    frags.add(Resource.newResource((URI)BundleFileLocatorHelperFactory.getFactory().getHelper().getBundleInstallLocation(frag).toURI()));
                }
                if (resEnum != null && resEnum.hasMoreElements() && (resourcesEntry = frag.getEntry("/META-INF/resources/")) != null) {
                    if (resfrags == null) {
                        resfrags = new ArrayList<Resource>();
                        context.setAttribute("org.eclipse.jetty.resources", resfrags);
                    }
                    resfrags.add(Resource.newResource((URL)BundleFileLocatorHelperFactory.getFactory().getHelper().getLocalURL(resourcesEntry)));
                }
                if (tldEnum == null || !tldEnum.hasMoreElements()) continue;
                if (tldfrags == null) {
                    tldfrags = new ArrayList<Resource>();
                    context.setAttribute("org.eclipse.jetty.tlds", tldfrags);
                }
                while (tldEnum.hasMoreElements()) {
                    URL tldUrl = (URL)tldEnum.nextElement();
                    tldfrags.add(Resource.newResource((URL)BundleFileLocatorHelperFactory.getFactory().getHelper().getLocalURL(tldUrl)));
                }
            }
            catch (Exception e) {
                LOG.warn("Unable to locate the bundle " + frag.getBundleId(), (Throwable)e);
            }
        }
        super.preConfigure(context);
    }
}

